package cn.com.bril.androidocr.studio.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfWriter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;


/**
 * Created by sunny on 2017-12-12.
 */

public class ItextUtils {

    /**
     * 将图片转换成pdf文件 imgFilePath 需要被转换的img所存放的位置。
     * 例如imgFilePath="D:\\projectPath\\55555.jpg"; pdfFilePath 转换后的pdf所存放的位置
     * 例如pdfFilePath="D:\\projectPath\\test.pdf";
     *
     * @return boolean
     * @throws IOException
     */
    public static boolean exportPicToPdf(String txtPath,String pdfPath,String content){

        File file = new File(txtPath);
        File pdfFile=new File(pdfPath);
        String parentPath=pdfFile.getParent();
        if(!new File(parentPath).exists())
            new File(parentPath).mkdirs();
        if (file.exists() && !pdfFile.exists()) {
            Document document = new Document();
            FileOutputStream fos = null;
            try {
                new File(pdfPath).createNewFile();
                fos = new FileOutputStream(pdfPath);
                PdfWriter.getInstance(document, fos);

                // 添加PDF文档的某些信息，比如作者，主题等等
                document.addAuthor("bril");
                document.addSubject("文档扫描-pdf");
                document.addTitle("文档扫描-pdf");
                // 页边空白
                document.setMargins(10, 20, 80, 10);
                // 设置文档的大小
                document.setPageSize(PageSize.A4);
                // 打开文档
                document.open();

                // 读取一个图片
                Image image = Image.getInstance(txtPath);
                float imageHeight = image.getScaledHeight();
                float imageWidth = image.getScaledWidth();
                int i = 0;
                while (imageHeight > 500 || imageWidth > 500) {
                    image.scalePercent(100 - i);
                    i++;
                    imageHeight = image.getScaledHeight();
                    imageWidth = image.getScaledWidth();
                    System.out.println("imageHeight->" + imageHeight);
                    System.out.println("imageWidth->" + imageWidth);
                }

                image.setAlignment(Image.ALIGN_CENTER);
                // //设置图片的绝对位置
                // image.setAbsolutePosition(0, 0);
                // image.scaleAbsolute(500, 400);
                // 插入一个图片
                document.add(image);

            } catch (DocumentException de) {
                System.out.println(de.getMessage());
            } catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
            document.close();
            //删除文件
            file.delete();
            try {
                fos.flush();
                fos.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            return true;
        }else if(file.exists() && pdfFile.exists()){
            return true;
        }
        else {
            return false;
        }
    }
    public static boolean StringToPdf(String content,String pdfPath){

        File pdfFile=new File(pdfPath);
        String parentPath=pdfFile.getParent();
        if(!new File(parentPath).exists())
            new File(parentPath).mkdirs();
        if (!pdfFile.exists()) {
            Document document = new Document();
            FileOutputStream fos = null;
            try {
              pdfFile.createNewFile();
                fos = new FileOutputStream(pdfPath);
                PdfWriter.getInstance(document, fos);

                // 添加PDF文档的某些信息，比如作者，主题等等
                document.addAuthor("bril");
                document.addSubject("文档扫描-pdf");
                document.addTitle("文档扫描-pdf");
                // 页边空白
                document.setMargins(10, 20, 80, 10);
                // 设置文档的大小
                document.setPageSize(PageSize.A4);
                // 打开文档

                document.open();

                BaseFont bfHei = BaseFont.createFont("STSong-Light",
                        "UniGB-UCS2-H", BaseFont.NOT_EMBEDDED);
                Font FontChinese = new Font(bfHei, 28, Font.NORMAL);
                Paragraph paragraph=new Paragraph(content,FontChinese);
                paragraph.setAlignment(Element.ALIGN_LEFT);
                paragraph.setLeading(30.0f);
                document.add(paragraph);


            } catch (DocumentException de) {
                System.out.println(de.getMessage());
            } catch (IOException ioe) {;
                System.out.println(ioe.getMessage());
            }
            document.close();
            try {
                fos.flush();
                fos.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            return true;
        }else if(pdfFile.exists()){
            return true;
        }
        else {
            return false;
        }
    }

}
