package cn.com.bril.androidocr.studio.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;

import com.scanlibrary.ScanConstants;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by csk on 2018-1-3.
 */

public class FileUtil {

    public static String saveBitmap(Context context, Bitmap mBitmap) {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new
                Date());
        String savePath= ScanConstants.IMAGE_PATH+"/" + timeStamp +
                ".jpg";

        File filePic;
        try {
            filePic = new File(savePath);
            if (!filePic.exists()) {
                filePic.getParentFile().mkdirs();
                filePic.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(filePic);
            mBitmap.compress(Bitmap.CompressFormat.JPEG, 100, fos);
            fos.flush();
            fos.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return null;
        }

        return filePic.getAbsolutePath();
    }

    //文件夹创建
    public static void creatDir(String path){
        if(!isFileExist(path)){
            File file=new File(path);
            if(!file.exists())
                file.mkdirs();
        }
    }

   //判断文件是否存在
    public static boolean isFileExist(String path){
        try
        {
            File f=new File(path);
            if(!f.exists())
            {
                return false;
            }

        }
        catch (Exception e)
        {
            return false;
        }

        return true;
    }

    public static Uri getFileUri(Context context,File file){
        Uri tempFileUri=null;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            tempFileUri = FileProvider.getUriForFile(context.getApplicationContext(),
                    "com.scanlibrary.provider", // As defined in Manifest
                    file);
        } else {
            tempFileUri = Uri.fromFile(file);
        }
        return tempFileUri;
    }

}
