package cn.com.bril.androidocr.studio.ui.fragment;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.Toast;

import com.google.gson.reflect.TypeToken;

import org.json.JSONException;
import org.json.JSONObject;
import org.xutils.common.Callback;
import org.xutils.http.RequestParams;
import org.xutils.x;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.OcrRootBean;
import cn.com.bril.androidocr.studio.beans.ShareInfo;
import cn.com.bril.androidocr.studio.beans.ShareRootBean;
import cn.com.bril.androidocr.studio.configs.Configs;
import cn.com.bril.androidocr.studio.configs.RequestConfig;
import cn.com.bril.androidocr.studio.http.HttpHolder;
import cn.com.bril.androidocr.studio.http.MainHttpCallBack;
import cn.com.bril.androidocr.studio.interf.HandleMenuListener;
import cn.com.bril.androidocr.studio.interf.OnHttpListener;
import cn.com.bril.androidocr.studio.ui.activity.OcrDetailActivity;
import cn.com.bril.androidocr.studio.ui.adapter.FragmentListAdapter;
import cn.com.bril.androidocr.studio.ui.adapter.ShareFragmentAdapter;
import cn.com.bril.androidocr.studio.ui.pulltorefresh.PullToRefreshBase;
import cn.com.bril.androidocr.studio.ui.pulltorefresh.PullToRefreshListView;
import cn.com.bril.androidocr.studio.utils.CustomDialogUtils;
import cn.com.bril.androidocr.studio.utils.FileType;
import cn.com.bril.androidocr.studio.utils.FileUtil;
import cn.com.bril.androidocr.studio.utils.GsonUtil;
import cn.com.bril.androidocr.studio.utils.HttpUtil;
import cn.com.bril.androidocr.studio.utils.ShareUtil;

/**
 * Created by sunny on 2018-3-12.
 */

public class ShareFragment extends Fragment implements OnHttpListener, FragmentListAdapter.ListTextClickListener, View.OnClickListener , ShareFragmentAdapter.ListFileClickListener {
    private PullToRefreshListView pullToRefreshListView;
    private ListView listView;
    private Context context;
    private ShareFragmentAdapter adaper;
    private List<ShareRootBean> beanList=new ArrayList<>();
    private boolean isUpdate=false,hasMoreData=false;
    private int page=1,pageSize=10;
    private FragmentListAdapter.ListTextClickListener listTextClickListener;
    private List<ShareRootBean> selectedInfos=new ArrayList<>();
    private ExportFragment.NoticeMessageToMain messageToMain;
    private HandleMenuListener handleMenuListener;
    private ProgressDialog dialog;
    private int curLoadIndex;
    List<ShareRootBean> loadBeans;

    private Handler handler=new Handler(){
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if(msg.what==1){
                curLoadIndex++;
                if (curLoadIndex < loadBeans.size())
                    downLoadFile(loadBeans.get(curLoadIndex).getIncludes().getCc_file().getFilePath(),loadBeans.get(curLoadIndex).getIncludes().getCc_file().getFileName(),"batch");
                else {
                    dialog.dismiss();
//                    batchCreateFiles();
                    batchShareAdd();
                }
            }else if(msg.what==0){
                Toast.makeText(context, selectedInfos.get(curLoadIndex).getIncludes().getCc_file().getFileName() + "下载失败，请稍后重试", Toast.LENGTH_SHORT).show();
            }else if(msg.what==2){
                Toast.makeText(context, "下载已完成，再次点击可打开", Toast.LENGTH_SHORT).show();
            }else if(msg.what==2){
                Toast.makeText(context, "下载失败，请稍后重试", Toast.LENGTH_SHORT).show();
            }
        }
    };

    private ArrayList<Uri> shareFileUris;
    private EditText reNameEdit;
    private AlertDialog reNameDialog;
    private ShareRootBean clickedFileItem;
    private int createCount;//创建文件信息个数

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.context=context;
        handleMenuListener= (HandleMenuListener) context;
        messageToMain= (ExportFragment.NoticeMessageToMain) context;

    }

    public List<ShareRootBean> getSelectedInfos() {
        return selectedInfos;
    }

    public void setSelectedInfos(List<ShareRootBean> selectedInfos) {
        this.selectedInfos = selectedInfos;
    }

    public void handleDeletAction(){

        List<ShareInfo> infos=new ArrayList<>();
        for(ShareRootBean bean:selectedInfos)
            infos.add(bean.getSuperior());
        HttpHolder.batchDeleteShareRecord(infos,new MainHttpCallBack("delete",this));
    }

    public void handleShareAction(){
        getNotLoadFilesAndLoad(selectedInfos);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        View view=inflater.inflate(R.layout.listview_layout,null);

        initViews(view);

        initEvents();

        dialog=new ProgressDialog(context);

        return view;
    }

    public void initViews(View view){

        pullToRefreshListView= (PullToRefreshListView) view.findViewById(R.id.pullrefreshView);
        pullToRefreshListView.setPullLoadEnabled(true);
        pullToRefreshListView.setPullRefreshEnabled(true);
        listView=pullToRefreshListView.getRefreshableView();

        adaper=new ShareFragmentAdapter(context, beanList, this, new ShareFragmentAdapter.AdapterRadioSelectedListener() {
            @Override
            public void adapterRadioSelectedCallBack() {
                setSelectedInfos(adaper.getSelectedInfo());
                messageToMain.noticeMessage(adaper.getSelectedInfo().size());

            }
        });
        adaper.setFileOnClickListener(this);
        listView.setAdapter(adaper);
    }

    public void initEvents(){

        pullToRefreshListView.setOnRefreshListener(new PullToRefreshBase.OnRefreshListener<ListView>() {
            @Override
            public void onPullDownToRefresh(PullToRefreshBase<ListView> refreshView) {
                isUpdate=true;
                hasMoreData=true;
                page=1;
                if(HttpUtil.isNetworkConnected(context))
                    getShareRecord();
                else{
                    Toast.makeText(context,"暂无网络连接",Toast.LENGTH_LONG).show();
                    refreshView.onPullDownRefreshComplete();
                }
            }

            @Override
            public void onPullUpToRefresh(PullToRefreshBase<ListView> refreshView) {
                isUpdate=false;
                page++;
                if(HttpUtil.isNetworkConnected(context))
                    getShareRecord();
                else{
                    Toast.makeText(context,"暂无网络连接",Toast.LENGTH_LONG).show();
                    refreshView.onPullDownRefreshComplete();
                }
            }
        });
        listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener() {
            @Override
            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
                handleMenuListener.setHandleMenu(View.VISIBLE);
                adaper.setRadioShow(View.VISIBLE);
                return true;
            }
        });
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                String filePath=beanList.get(position).getIncludes().getCc_file().getFileSource();
                String content=beanList.get(position).getIncludes().getCc_file().getContent();
                Intent intent=new Intent(context, OcrDetailActivity.class);
                intent.putExtra("image",filePath);
                intent.putExtra("content",content);
                context.startActivity(intent);
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        pullToRefreshListView.doPullRefreshing(true,500);
        if(adaper!=null)
            adaper.setRadioShow(View.GONE);
    }

    public void setAllItemChecked(boolean flg){
        adaper.setRadioAllSelected(flg);
    }

    public void setCheckBoxShow(int v){
        adaper.setRadioShow(v);
    }
    //获取分享列表
    private void getShareRecord(){
        RequestParams params=new RequestParams(RequestConfig.SHARE_LIST_URL);
        params.addBodyParameter("pageNo",page+"");
        params.addBodyParameter("sortItem","create_time");
        params.addBodyParameter("sortOrder","desc");
        String userInfo= Configs.USER_NAME+"_"+Configs.USER_ID;
        String json="{\"cc_sharing_record\":{\"sharing_peple\":{\"equalTo\":\""+userInfo+"\"},\"type\":{\"equalTo\":0}}}";
        params.addBodyParameter("filters",json);
        String json2="{\"cc_file\":{\"includes\":[\"file_id\"]}}";
        params.addBodyParameter("includes",json2);
        x.http().get(params,new MainHttpCallBack("list",this));
    }
    //下载文件
    private void downLoadFile(String path, String fileName, final String type) {
        dialog.setMessage("正在下載...");
        dialog.show();
        RequestParams params=new RequestParams(RequestConfig.DOWN_LOAD_URL);
        params.addBodyParameter("fileName",path);
        params.addBodyParameter("downloadName",fileName);
        params.setSaveFilePath(Configs.WORD_BASE+"/"+fileName);
        x.http().get(params, new Callback.CommonCallback<File>() {
            @Override
            public void onSuccess(File result) {
                if(type.equals("batch")){
                    dialog.dismiss();
                    handler.sendEmptyMessage(1);
                }else{
                    handler.sendEmptyMessage(2);
                }
            }
            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
                dialog.dismiss();
                handler.sendEmptyMessage(0);
                Toast.makeText(context,"下载失败", Toast.LENGTH_SHORT).show();
            }
            @Override
            public void onCancelled(CancelledException cex) {
            }
            @Override
            public void onFinished() {
            }
        });
    }
    //添加分享记录
    private void batchShareAdd() {
        List<ShareInfo> list=new ArrayList<>();
        ShareInfo superior;
        for(ShareRootBean bean: selectedInfos){
            superior=new ShareInfo();
            superior.setFileName(bean.getIncludes().getCc_file().getFileName());
            superior.setFilePath(bean.getIncludes().getCc_file().getFilePath());
            superior.setType("0");
            superior.setSharingPeple(bean.getSuperior().getSharingPeple());
            list.add(superior);
        }
        HttpHolder.batchShareCcFile(list,new MainHttpCallBack("batch_share",this));
    }
    //获取待下载项&&分享
    private void getNotLoadFilesAndLoad(List<ShareRootBean> list) {
        loadBeans = new ArrayList<>();
        shareFileUris = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            OcrRootBean.Cc_file cc_file = list.get(i).getIncludes().getCc_file();
            String type = cc_file.getFileName().substring(cc_file.getFileName().lastIndexOf(".") + 1);
            String filePath = "";
            if ("doc".equals(type) || "docs".equals(type))
                filePath = Configs.WORD_BASE + "/" + cc_file.getFileName();
            else if ("txt".equals(type))
                filePath = Configs.TXT_BASE + "/" + cc_file.getFileName();
            else if ("pdf".equals(type))
                filePath = Configs.PDF_BASE + "/" + cc_file.getFileName();
            shareFileUris.add(FileUtil.getFileUri(context,new File(filePath)));
            if (!FileUtil.isFileExist(filePath))
                loadBeans.add(selectedInfos.get(i));

        }
        if (loadBeans.size() != 0) {
            dialog.setMessage("正在下载，请稍后");
            dialog.show();
            curLoadIndex=0;
            downLoadFile(loadBeans.get(curLoadIndex).getIncludes().getCc_file().getFilePath(),loadBeans.get(0).getIncludes().getCc_file().getFileName(),"batch");
        }else{
            batchShareAdd();
        }
    }

    private void reNameFile() {
        String newName=reNameEdit.getText().toString().trim();
        if(!newName.equals(clickedFileItem.getSuperior().getFileName())){
            if(!newName.contains("."))
                newName=newName+clickedFileItem.getSuperior().getFileName().substring(clickedFileItem.getSuperior().getFileName().indexOf("."));
            HttpHolder.editShareRecord(clickedFileItem.getSuperior().getId(),newName,new MainHttpCallBack("edit",this));
        }
    }

    @Override
    public void success(String type, String result) {
        if(type.equals("list")){
            List<ShareRootBean> been=GsonUtil.getInstance().fromJson(result,new TypeToken<List<ShareRootBean>>(){}.getType());
            if(isUpdate){
                beanList.clear();
            }
            beanList.addAll(been);
            if(been.size()==0){
                Toast.makeText(context,"暂无数据",Toast.LENGTH_SHORT).show();
            }
            else if(been.size()<10&& been.size()>0){
                hasMoreData=false;
            }
            else
                hasMoreData=true;
            adaper.notifyDataSetChanged();

            pullToRefreshListView.onPullUpRefreshComplete();
            pullToRefreshListView.onPullDownRefreshComplete();
            pullToRefreshListView.setHasMoreData(hasMoreData);
        }else if(type.equals("batch_share")){
            List<ShareInfo> info=GsonUtil.getInstance().fromJson(result,new TypeToken<List<ShareInfo>>(){}.getType());
            if(info!=null ){
                handleMenuListener.setHandleMenu(View.GONE);
                ShareUtil.batchShareFile(context,shareFileUris);
                adaper.setRadioShow(View.GONE);
            }
        }else if(type.equals("delete")){
            try {
                JSONObject object = new JSONObject(result);
                String data = object.getString("message");
                if (data.contains("success")) {
                    Toast.makeText(context, "删除成功", Toast.LENGTH_SHORT).show();
                    handleMenuListener.setHandleMenu(View.GONE);
                    adaper.setRadioShow(View.GONE);
                    pullToRefreshListView.doPullRefreshing(true,100);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }else if ("edit".equals(type)) {
            OcrRootBean.Cc_file file=GsonUtil.getInstance().fromJson(result,new TypeToken<OcrRootBean.Cc_file>(){}.getType());
            if(null!=file){
                Toast.makeText(context, "修改成功", Toast.LENGTH_SHORT).show();
                pullToRefreshListView.doPullRefreshing(true,100);
            }else
                Toast.makeText(context, "修改失败，请重试", Toast.LENGTH_SHORT).show();
        }
        else if("single_create".equals(type)){
            OcrRootBean.Cc_file cc_file=GsonUtil.getInstance().fromJson(result,new TypeToken<OcrRootBean.Cc_file>(){}.getType());
            if(cc_file!=null){
                createCount++;
                if(createCount==selectedInfos.size())
                    batchShareAdd();
            }
        }
    }

    @Override
    public void error(String type, Throwable t) {
        Log.e("TAG",t.getMessage());
        if(type.equals("list")){
            pullToRefreshListView.onPullUpRefreshComplete();
            pullToRefreshListView.onPullDownRefreshComplete();
        }
        Toast.makeText(context,"网络异常，请检查",Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onListTextCallBack(int position) {
        clickedFileItem=beanList.get(position);
        View view = LayoutInflater.from(context).inflate(R.layout.rename_dialog_layout, null);
        view.findViewById(R.id.normal_name).setOnClickListener(this);
        view.findViewById(R.id.positive).setOnClickListener(this);
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setView(view);
        reNameEdit = (EditText) view.findViewById(R.id.edit);
        reNameEdit.setHint(clickedFileItem.getSuperior().getFileName());
        reNameDialog = builder.create();
        reNameDialog.show();
        CustomDialogUtils.setDialogSize((Activity) context, dialog);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()){
            case R.id.positive:
                reNameFile();
                reNameDialog.dismiss();
                break;
            case R.id.normal_name:
                reNameDialog.dismiss();
                break;
        }
    }

    @Override
    public void onListFileCallBack(int position) {
        String path=beanList.get(position).getIncludes().getCc_file().getFilePath();
        String fileName=beanList.get(position).getIncludes().getCc_file().getFileName();
        if(fileName.contains(".pdf")){
            if(FileUtil.isFileExist(Configs.PDF_BASE+"/"+fileName)){
                FileType.openFile(context,new File(Configs.PDF_BASE+"/"+fileName));
            }
            else{
                downLoadFile(path, fileName,"single");
            }
        }else if(fileName.contains(".doc")|| fileName.contains(".docs")){
            if(FileUtil.isFileExist(Configs.WORD_BASE+"/"+fileName)){
                FileType.openFile(context,new File(Configs.WORD_BASE+"/"+fileName));
            }
            else
                downLoadFile(path, fileName,"single");
        }else if(fileName.contains(".txt")){
            if(FileUtil.isFileExist(Configs.TXT_BASE+"/"+fileName)){
                FileType.openFile(context,new File(Configs.TXT_BASE+"/"+fileName));
            }
            else
                downLoadFile(path, fileName,"single");
        }
    }
}
