package cn.com.bril.androidocr.studio.ui.fragment;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.Toast;

import com.google.gson.reflect.TypeToken;

import org.json.JSONException;
import org.json.JSONObject;
import org.xutils.common.Callback;
import org.xutils.http.RequestParams;
import org.xutils.x;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.OcrRootBean;
import cn.com.bril.androidocr.studio.beans.ShareInfo;
import cn.com.bril.androidocr.studio.configs.Configs;
import cn.com.bril.androidocr.studio.configs.RequestConfig;
import cn.com.bril.androidocr.studio.http.HttpHolder;
import cn.com.bril.androidocr.studio.http.MainHttpCallBack;
import cn.com.bril.androidocr.studio.interf.HandleMenuListener;
import cn.com.bril.androidocr.studio.interf.OnHttpListener;
import cn.com.bril.androidocr.studio.ui.activity.OcrDetailActivity;
import cn.com.bril.androidocr.studio.ui.adapter.FragmentListAdapter;
import cn.com.bril.androidocr.studio.ui.pulltorefresh.PullToRefreshBase;
import cn.com.bril.androidocr.studio.ui.pulltorefresh.PullToRefreshListView;
import cn.com.bril.androidocr.studio.utils.CustomDialogUtils;
import cn.com.bril.androidocr.studio.utils.FileType;
import cn.com.bril.androidocr.studio.utils.FileUtil;
import cn.com.bril.androidocr.studio.utils.GsonUtil;
import cn.com.bril.androidocr.studio.utils.HttpUtil;
import cn.com.bril.androidocr.studio.utils.ShareUtil;

/**
 * Created by sunny on 2018-3-12.
 */

public class ExportFragment extends Fragment implements OnHttpListener,FragmentListAdapter.ListTextClickListener,View.OnClickListener,FragmentListAdapter.ListFileClickListener {


    private PullToRefreshListView pullToRefreshListView;
    private ListView listView;
    private Context context;
    private FragmentListAdapter adaper;
    private List<OcrRootBean> exportInfos= new ArrayList<>();
    private boolean isUpdate=false,hasMoreData=false;
    private int page=1,pageSize=10;
    private AlertDialog dialog;//renameDialog
    private ProgressDialog progressDialog;
    private FragmentListAdapter.ListTextClickListener listener;
    private HandleMenuListener handleMenuListener;
    private List<OcrRootBean> selectedInfos=new ArrayList<>();
    private NoticeMessageToMain messageToMain;
    private ArrayList<OcrRootBean> loadBeans;//需下载项
    private int curLoadIndex;
    private Handler handler=new Handler(){
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if(msg.what==1){
                curLoadIndex++;
                if (curLoadIndex < loadBeans.size())
                    downLoadFile(loadBeans.get(curLoadIndex).getIncludes().getCc_file().getFilePath(),loadBeans.get(curLoadIndex).getIncludes().getCc_file().getFileName(),"batch_load");
                else {
                    progressDialog.dismiss();
                    batchShareAdd();
                }
            }else if(msg.what==0){
                Toast.makeText(context, selectedInfos.get(curLoadIndex).getIncludes().getCc_file().getFileName() + "下载失败，请稍后重试", Toast.LENGTH_SHORT).show();
            }else if(msg.what==2){
                Toast.makeText(context, "下载已完成，再次点击可打开", Toast.LENGTH_SHORT).show();
            }
        }
    };
    private EditText reNameEdit;
    private OcrRootBean.Cc_file clickedFileItem;
    private int createCount;//分享时创建文件信息数量记录
//    private List<OcrRootBean.Cc_file> shareFileInfos;
    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.context=context;
        handleMenuListener= (HandleMenuListener) context;
        messageToMain= (NoticeMessageToMain) context;
    }

    public List<OcrRootBean> getSelectedInfos() {
        return selectedInfos;
    }

    public void setSelectedInfos(List<OcrRootBean> selectedInfos) {
        this.selectedInfos = selectedInfos;
    }
    //批量删除
    public void handleDeleteAction(){
        List<OcrRootBean.Superior> superiors=new ArrayList<>();
        for(OcrRootBean bean: selectedInfos){
            superiors.add(bean.getSuperior());
        }
        HttpHolder.volumeDelete(superiors, this);
    }
    //批量分享响应
    public void handleShareAction(){
        getNotLoadFilesAndLoad(selectedInfos);
    }
    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        View view=inflater.inflate(R.layout.listview_layout,null);

        initViews(view);

        initEvents();

        progressDialog=new ProgressDialog(context);
        return view;
    }

    public void initViews(View view){

        pullToRefreshListView= (PullToRefreshListView) view.findViewById(R.id.pullrefreshView);
        pullToRefreshListView.setPullLoadEnabled(true);
        pullToRefreshListView.setPullRefreshEnabled(true);
        listView=pullToRefreshListView.getRefreshableView();
        adaper=new FragmentListAdapter(context, exportInfos , this, new FragmentListAdapter.AdapterRadioSelectedListener() {
            @Override
            public void adapterRadioSelectedCallBack() {
                setSelectedInfos(adaper.getSelectedInfo());
                messageToMain.noticeMessage(adaper.getSelectedInfo().size());
            }
        });
        adaper.setFileOnClickListener(this);
        listView.setAdapter(adaper);

    }

    public void initEvents(){

        pullToRefreshListView.setOnRefreshListener(new PullToRefreshBase.OnRefreshListener<ListView>() {
            @Override
            public void onPullDownToRefresh(PullToRefreshBase<ListView> refreshView) {
                isUpdate=true;
                hasMoreData=true;
                page=1;
                if(HttpUtil.isNetworkConnected(context))
                    getExportRecord();
                else{
                    Toast.makeText(context,"暂无网络连接",Toast.LENGTH_LONG).show();
                    refreshView.onPullDownRefreshComplete();
                }
            }

            @Override
            public void onPullUpToRefresh(PullToRefreshBase<ListView> refreshView) {
                isUpdate=false;
                page++;
                if(HttpUtil.isNetworkConnected(context))
                    getExportRecord();
                else{
                    Toast.makeText(context,"暂无网络连接",Toast.LENGTH_LONG).show();
                    refreshView.onPullDownRefreshComplete();
                }
            }
        });

        listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener() {
            @Override
            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
                handleMenuListener.setHandleMenu(View.VISIBLE);
                adaper.setRadioShow(View.VISIBLE);
                return true;
            }
        });
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                String filePath=exportInfos.get(position).getIncludes().getCc_file().getFileSource();
                String content=exportInfos.get(position).getIncludes().getCc_file().getContent();
                Intent intent=new Intent(context, OcrDetailActivity.class);
                intent.putExtra("image",filePath);
                intent.putExtra("content",content);
                context.startActivity(intent);
            }
        });
    }

    private ArrayList<Uri> shareFileUris;
    //获取待下载项&&分享
    private void getNotLoadFilesAndLoad(List<OcrRootBean> list) {
        loadBeans = new ArrayList<>();
        shareFileUris = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            OcrRootBean.Cc_file cc_file = list.get(i).getIncludes().getCc_file();
            String type = cc_file.getFileName().substring(cc_file.getFileName().indexOf(".") + 1);
            String filePath = "";
            if ("doc".equals(type) || "docs".equals(type)){
                filePath = Configs.WORD_BASE + "/" + cc_file.getFileName();
                filePath="sdcard/wuzhihuaOA/docs/"+cc_file.getFileName();
            }
            else if ("txt".equals(type)){
                filePath = Configs.TXT_BASE + "/" + cc_file.getFileName();
                filePath="sdcard/wuzhihuaOA/txts/"+cc_file.getFileName();
            }
            else if ("pdf".equals(type)){
                filePath = Configs.PDF_BASE + "/" + cc_file.getFileName();
                filePath="sdcard/wuzhihuaOA/pdfs/"+cc_file.getFileName();
            }
            File file=new File(filePath);
            boolean isf=file.exists();
            shareFileUris.add(Uri.parse(filePath));//FileUtil.getFileUri(context,new File(filePath))

            if (!FileUtil.isFileExist(filePath))
                loadBeans.add(selectedInfos.get(i));
        }
        if (loadBeans.size() != 0) {
            progressDialog.setMessage("正在下载，请稍后");
            progressDialog.show();
            curLoadIndex=0;
            downLoadFile(loadBeans.get(curLoadIndex).getIncludes().getCc_file().getFilePath(),loadBeans.get(0).getIncludes().getCc_file().getFileName(),"batch_load");
        }else{
//            batchCreateFiles();
            batchShareAdd();
        }
    }

    private void downLoadFile(String path, String fileName, final String type) {
        RequestParams params=new RequestParams(RequestConfig.DOWN_LOAD_URL);
        params.addBodyParameter("fileName",path);
        params.addBodyParameter("downloadName",fileName);
        String url="";
        if(fileName.contains("txt")){
            url=Configs.TXT_BASE+"/"+fileName;
//            url="sdcard/wuzhihuaOA/txts/"+fileName;
        }

        else if(fileName.contains("doc")){
            url=Configs.WORD_BASE+"/"+fileName;
//            url="sdcard/wuzhihuaOA/docs/"+fileName;
        }

        params.setSaveFilePath(url);
        x.http().get(params, new Callback.CommonCallback<File>() {
            @Override
            public void onSuccess(File result) {
                if(type.equals("batch_load")){

                    handler.sendEmptyMessage(1);
                }else{
                    handler.sendEmptyMessage(2);
                }
            }
            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
                Log.e("TAG", "onError: "+ex.getMessage());
                handler.sendEmptyMessage(0);
            }
            @Override
            public void onCancelled(CancelledException cex) {
            }
            @Override
            public void onFinished() {
            }
        });
    }
    //获取列表
    private void getExportRecord(){
        RequestParams params=new RequestParams(RequestConfig.EXPORT_RECORD_URL);
        params.addBodyParameter("pageNo",page+"");
        params.addBodyParameter("sortItem","create_time");
        params.addBodyParameter("sortOrder","desc");
        String userInfo= Configs.USER_NAME+"_"+Configs.USER_ID;
        String json="{\"cc_export_record\":{\"export_user\":{\"equalTo\":\""+userInfo+"\"},\"type\":{\"equalTo\":\"0\"}}}";
        params.addBodyParameter("filters",json);
        String json2="{\"cc_file\":{\"includes\":[\"file_id\"]}}";
        params.addBodyParameter("includes",json2);
        x.http().get(params,new MainHttpCallBack("list",this));
    }

    //批量分享
    private void batchShareAdd()  {
        List<ShareInfo> list=new ArrayList<>();
        ShareInfo superior;
        for(OcrRootBean bean: selectedInfos){
            superior=new ShareInfo();
            superior.setFileName(bean.getIncludes().getCc_file().getFileName());
            superior.setFilePath(bean.getIncludes().getCc_file().getFilePath());
            superior.setFileId(bean.getIncludes().getCc_file().getId());
            superior.setType("0");
            superior.setSharingPeple(bean.getSuperior().getExportUser());
            list.add(superior);
        }
        HttpHolder.batchShareCcFile(list,new MainHttpCallBack("batch_share",this));
    }

    public void setAllItemChecked(boolean flg){
        adaper.setRadioAllSelected(flg);
    }

    public void setCheckBoxShow(int v){
        adaper.setRadioShow(v);
    }

    private void reNameFile() {
        String url = RequestConfig.EDIT_FILE_URL + clickedFileItem.getId() + "/edit";
        RequestParams params = new RequestParams(url);
        params.addHeader("X-Auth-Token", "1");
        String lastName=clickedFileItem.getFileName();
        params.addBodyParameter("fileName", reNameEdit.getText().toString()+lastName.substring(lastName.indexOf(".")));
        //缺少修改人
        x.http().post(params, new MainHttpCallBack("edit", this));
    }

    @Override
    public void onResume() {
        super.onResume();
        pullToRefreshListView.doPullRefreshing(true,500);
        if(adaper!=null)
            adaper.setRadioShow(View.GONE);
    }

    @Override
    public void success(String type, String result) {
        if(type.equals("list")){
            List<OcrRootBean> been=GsonUtil.getInstance().fromJson(result,new TypeToken<List<OcrRootBean>>(){}.getType());
            if(isUpdate){
                exportInfos.clear();
            }
            exportInfos.addAll(been);
            if(been.size()==0){
                Toast.makeText(context,"暂无数据",Toast.LENGTH_SHORT).show();
            }
            else if(been.size()<10&& been.size()>0){
                hasMoreData=false;
            }
            else
                hasMoreData=true;
            adaper.notifyDataSetChanged();
            pullToRefreshListView.onPullUpRefreshComplete();
            pullToRefreshListView.onPullDownRefreshComplete();
            pullToRefreshListView.setHasMoreData(hasMoreData);
        }else if ("edit".equals(type)) {
            OcrRootBean.Cc_file file=GsonUtil.getInstance().fromJson(result,new TypeToken<OcrRootBean.Cc_file>(){}.getType());
            if(null!=file){
                Toast.makeText(context, "修改成功", Toast.LENGTH_SHORT).show();
                pullToRefreshListView.doPullRefreshing(true,100);
            }else
                Toast.makeText(context, "修改失败，请重试", Toast.LENGTH_SHORT).show();

        }else if("batch_share".equals(type)){
            List<ShareInfo> info=GsonUtil.getInstance().fromJson(result,new TypeToken<List<ShareInfo>>(){}.getType());
            if(info!=null ) {
                adaper.setRadioShow(View.GONE);
                handleMenuListener.setHandleMenu(View.GONE);
                ShareUtil.batchShareFile(context,shareFileUris);
            }
        }else if("delete".equals(type)){
            try {
                JSONObject object = new JSONObject(result);
                String data = object.getString("message");
                if (data.contains("success")) {
                    Toast.makeText(context, "删除成功", Toast.LENGTH_SHORT).show();
                    handleMenuListener.setHandleMenu(View.GONE);
                    adaper.setRadioShow(View.GONE);
                    pullToRefreshListView.doPullRefreshing(true,100);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else if("single_create".equals(type)){
            OcrRootBean.Cc_file cc_file=GsonUtil.getInstance().fromJson(result,new TypeToken<OcrRootBean.Cc_file>(){}.getType());
            if(cc_file!=null){
                createCount++;
//                shareFileInfos.add(cc_file);
                if(createCount==selectedInfos.size())
                    batchShareAdd();
            }
        }
    }

    @Override
    public void error(String type, Throwable t) {
        Toast.makeText(context,"网络异常，请检查",Toast.LENGTH_SHORT).show();
        pullToRefreshListView.onPullUpRefreshComplete();
        pullToRefreshListView.onPullDownRefreshComplete();
    }

    @Override
    public void onListTextCallBack(int postion) {
        clickedFileItem=exportInfos.get(postion).getIncludes().getCc_file();
        View view = LayoutInflater.from(context).inflate(R.layout.rename_dialog_layout, null);
        view.findViewById(R.id.normal_name).setOnClickListener(this);
        view.findViewById(R.id.positive).setOnClickListener(this);
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setView(view);
        reNameEdit = (EditText) view.findViewById(R.id.edit);
        reNameEdit.setHint(clickedFileItem.getFileName());
        dialog = builder.create();
        dialog.show();
        CustomDialogUtils.setDialogSize((Activity) context, dialog);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()){
            case R.id.positive:
                reNameFile();
                dialog.dismiss();
                break;
            case R.id.normal_name:
                dialog.dismiss();
                break;
        }
    }

    @Override
    public void onListFileCallBack(int position) {
        String path=exportInfos.get(position).getIncludes().getCc_file().getFilePath();
        String fileName=exportInfos.get(position).getIncludes().getCc_file().getFileName();
        if(fileName.contains(".pdf")){
            if(FileUtil.isFileExist(Configs.PDF_BASE+"/"+fileName))
                FileType.openFile(context,new File(Configs.PDF_BASE+"/"+fileName));
            else{
                progressDialog.setMessage("正在下载...");
                progressDialog.show();
                downLoadFile(path, fileName,"single");
            }
        }else if(fileName.contains(".doc")|| fileName.contains(".docs")){
            if(FileUtil.isFileExist("sdcard/wuzhihuaOA/docs/"+fileName)){
                FileType.openFile(context,new File("sdcard/wuzhihuaOA/docs/"+fileName));
//                        FileType.openFile(context,"sdcard/wuzhihuaOA/docs/"+fileName);
//                        OpenFileUtil.openFile(context,"sdcard/wuzhihuaOA/docs/"+fileName);
            }
            else
                downLoadFile(path, fileName,"single");
        }else if(fileName.contains(".txt")){
            if(FileUtil.isFileExist("sdcard/wuzhihuaOA/txts/"+fileName)){
//                        FileType.openFile(context,"sdcard/wuzhihuaOA/txts/"+fileName);
//                        OpenFileUtil.openFile(context,"sdcard/wuzhihuaOA/txts/"+fileName);
                FileType.openFile(context,new File("sdcard/wuzhihuaOA/txts/"+fileName));
            }
            else
                downLoadFile(path, fileName,"single");
        }
    }

    public interface NoticeMessageToMain{
        void noticeMessage(int size);
    }

}
