package cn.com.bril.androidocr.studio.ui.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

import com.google.gson.reflect.TypeToken;

import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.json.JSONException;
import org.json.JSONObject;
import org.xutils.common.Callback;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import cn.com.bril.androidocr.studio.OcrApplication;
import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.ExportInfo;
import cn.com.bril.androidocr.studio.beans.Image;
import cn.com.bril.androidocr.studio.beans.OcrInfo;
import cn.com.bril.androidocr.studio.beans.ShareInfo;
import cn.com.bril.androidocr.studio.configs.Configs;
import cn.com.bril.androidocr.studio.configs.RequestConfig;
import cn.com.bril.androidocr.studio.http.HttpHolder;
import cn.com.bril.androidocr.studio.utils.GsonUtil;
import cn.com.bril.androidocr.studio.utils.ItextUtils;
import cn.com.bril.androidocr.studio.utils.ScreenUtil;
import cn.com.bril.androidocr.studio.utils.ShareUtil;


public class VertifyActivity extends AppCompatActivity  {

    @BindView(R.id.left_iv)
    LinearLayout lefIv;
    @BindView(R.id.topTitle)
    TextView topTitle;
    @BindView(R.id.rightTv)
    TextView rightTv;
    @BindView(R.id.content)
    TextView content;
    @BindView(R.id.scrollView)
    ScrollView scrollView;
    @BindView(R.id.rephoto)
    LinearLayout rephoto;
    @BindView(R.id.verrify)
    LinearLayout verrify;
    @BindView(R.id.left_tv)
    TextView leftTv;
    @BindView(R.id.right_iv)
    ImageView rightIv;
    @Nullable
    @BindView(R.id.topBarLayout)
    RelativeLayout topBarLayout;
    private TextView pdf, img, txt;
    private AlertDialog dialog;//导出菜单
    private RadioButton radio, radio1, radio2;
    private String recogniztion;
    private Image image;
    private PopupWindow mPopupWindow;

    private String statusType,sourceFilePath,thumPath;
    private OcrInfo ocrInfo,ocrInfo2;
    File shareFile;
    long fileSize;
    private String editFilename;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_vertify);
        OcrApplication.getInstance().addActivity(this);
        ButterKnife.bind(this);
//        lefIv.setVisibility(View.VISIBLE);
        leftTv.setText("文字识别结果");
        leftTv.setVisibility(View.VISIBLE);
        rightTv.setVisibility(View.GONE);
        rightIv.setVisibility(View.VISIBLE);
//        rightTv.setText("导出");
        image = (Image) getIntent().getSerializableExtra("image");
        sourceFilePath=getIntent().getStringExtra("sourceFile");
        thumPath=getIntent().getStringExtra("sourceThumFile");
        recogniztion = image.getRecogniztion();
        content.setText(recogniztion);
    }

    @OnClick({R.id.rephoto, R.id.verrify, R.id.left_iv,R.id.right_iv})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.left_iv:
                finish();
                break;
            case R.id.rephoto:
                Intent rec = new Intent(this, RecognizeActivity.class);
                rec.putExtra("type", 4);
                startActivity(rec);
                break;
            case R.id.verrify:
                Intent proofread = new Intent(this, ProofreadActivity.class);
                proofread.putExtra("image", image);
                startActivityForResult(proofread, 10);
                break;
            case R.id.right_iv:
                if(null== mPopupWindow )
                    showHandleMenu();
                else if(mPopupWindow!=null&&!mPopupWindow.isShowing())
                    showHandleMenu();
                break;
        }
    }

    //展示工具栏
    public void showHandleMenu() {
        View popupWindow = LayoutInflater.from(this).inflate(R.layout.action_menu_layout, null);
        mPopupWindow = new PopupWindow(popupWindow, LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        popupWindow.findViewById(R.id.export).setOnClickListener(clickListener);
        popupWindow.findViewById(R.id.share).setOnClickListener(clickListener);
        mPopupWindow.setTouchable(true);
        mPopupWindow.setOutsideTouchable(true);
        mPopupWindow.setBackgroundDrawable(new BitmapDrawable(getResources(), (Bitmap) null));
        mPopupWindow.showAsDropDown(rightIv);
//        backgroundAlpha(0.5f);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == Activity.RESULT_OK && requestCode == 10) {
            image = (Image) data.getSerializableExtra("image");
            recogniztion = image.getRecogniztion();
            content.setText(image.getRecogniztion());
        }
    }

    //导出选择视图
    private void showExportDialog(String type) {
        mPopupWindow.dismiss();
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        View view = getLayoutInflater().inflate(R.layout.export_layout, null);
        TextView textView= (TextView) view.findViewById(R.id.tilte);
        textView.setText(type);
        setDialogView(view);
        builder.setView(view);
        builder.setCancelable(true);
        dialog = builder.create();
        dialog.show();
        ScreenUtil.setDialogSize(this, dialog);
    }

    public void setDialogView(View view) {
        pdf = (TextView) view.findViewById(R.id.pdf);
        radio = (RadioButton) view.findViewById(R.id.radio);
        img = (TextView) view.findViewById(R.id.img);
        radio1 = (RadioButton) view.findViewById(R.id.radio1);
        txt = (TextView) view.findViewById(R.id.txt);
        radio2 = (RadioButton) view.findViewById(R.id.radio2);
        radio.setOnCheckedChangeListener(listener);
        radio1.setOnCheckedChangeListener(listener);
        radio2.setOnCheckedChangeListener(listener);
        view.findViewById(R.id.pdfLayout).setOnClickListener(clickListener);
        view.findViewById(R.id.imgLayout).setOnClickListener(clickListener);
        view.findViewById(R.id.txtLayout).setOnClickListener(clickListener);
    }

    private View.OnClickListener clickListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            switch (v.getId()) {
                case R.id.pdfLayout:
                    radio.setChecked(true);
                    radio.setEnabled(false);
                    radio1.setEnabled(false);
                    radio2.setEnabled(false);
                    break;
                case R.id.imgLayout:
                    radio1.setChecked(true);
                    radio.setEnabled(false);
                    radio1.setEnabled(false);
                    radio2.setEnabled(false);
                    break;
                case R.id.txtLayout:
                    radio2.setChecked(true);
                    radio.setEnabled(false);
                    radio1.setEnabled(false);
                    radio2.setEnabled(false);
                    break;
                case R.id.export:
                    mPopupWindow.dismiss();
                    statusType="0";
                    showExportDialog("导出");
                    break;
                case R.id.share:
                    mPopupWindow.dismiss();
                    statusType="1";
                    showExportDialog("分享");
//                    exportDoc("share");
                    break;
            }
        }
    };

    private CompoundButton.OnCheckedChangeListener listener = new CompoundButton.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

            radio.setEnabled(false);
            radio1.setEnabled(false);
            radio2.setEnabled(false);

            if (isChecked) {
                //设置只点击一次，其余均不可点击
                switch (buttonView.getId()) {
                    case R.id.radio:
                        pdf.setTextColor(getResources().getColor(R.color.yellow));
//                            handler.sendEmptyMessageDelayed(1,500);
//                        exportPdf();
                        exportDoc("export");
                        break;
                    case R.id.radio1:
                        img.setTextColor(getResources().getColor(R.color.yellow));
//                            handler.sendEmptyMessageDelayed(2,500);
                        exportDoc("export");
                        break;
                    case R.id.radio2:
                        txt.setTextColor(getResources().getColor(R.color.yellow));
                        exportTxt();
                        break;
                }
                dialog.dismiss();
            }
        }
    };

    private void exportPdf() {
        final String imgpath = image.getPath();
        final String pdfPath = Configs.PDF_BASE + "/" + imgpath.substring(imgpath.lastIndexOf("/") + 1).replace("jpg", "pdf");
        new Thread() {
            @Override
            public void run() {
                super.run();
                boolean flg = ItextUtils.StringToPdf(recogniztion, pdfPath);
                if (flg) {
                    HttpHolder.upLoadFile(RequestConfig.UP_FILE,pdfPath,new HttpCallBack("upload"));
                }
            }
        }.start();
    }
    private void exportTxt() {
        final EditText editText=new EditText(this);
        new AlertDialog.Builder(this).setView(editText).setTitle("文件命名").setPositiveButton("确定", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
               if(TextUtils.isEmpty(editText.getText().toString().trim())){
                   Toast.makeText(VertifyActivity.this,"请输入文件名",Toast.LENGTH_SHORT).show();
                   return;
               }
               editFilename=editText.getText().toString().trim();
               if(!editFilename.contains("txt"))
                   editFilename=editFilename+".txt";
               String path = Configs.TXT_BASE + "/" + editFilename;
                path="sdcard/wuzhihuaOA/txts/"+editFilename;
               try {
                   if (!new File(Configs.TXT_BASE).exists())
                       new File(Configs.TXT_BASE).mkdirs();
                   File textFile = new File(path);
                   if (textFile.exists())
                       textFile.delete();
                   textFile.createNewFile();
                   FileOutputStream outStream = new FileOutputStream(textFile);
                   outStream.write(recogniztion.getBytes());
                   outStream.close();
                   shareFile=textFile;
                   fileSize=textFile.length();
                   HttpHolder.upLoadFile(RequestConfig.UP_FILE,path,new HttpCallBack("upload"));
               } catch (IOException e) {
                   e.printStackTrace();
               }
            }
        }).setNegativeButton("取消",null).show();

    }

    private void exportDoc(String type) {
//        if (null == ocrInfo){
            final EditText editText=new EditText(this);
            new AlertDialog.Builder(this).setView(editText).setTitle("文件命名").setPositiveButton("确定", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    if(TextUtils.isEmpty(editText.getText().toString())){
                        Toast.makeText(VertifyActivity.this,"请输入文件名",Toast.LENGTH_SHORT).show();
                        return;
                    }
                    editFilename = editText.getText().toString();

                    if(!editFilename.contains("doc"))
                        editFilename=editFilename+".doc";
                    File file;
                    try {
//                        String filename = image.getName().replace("jpg", "docs");
                        if (!new File(Configs.WORD_BASE).exists())
                            new File(Configs.WORD_BASE).mkdirs();
                        String path = Configs.WORD_BASE + "/" + editFilename;
                        path="sdcard/wuzhihuaOA/docs/"+editFilename;
                        file=new File(path);
                        if(file.exists())
                            file.delete();
                        file.createNewFile();
                        String content =  recogniztion;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
                        POIFSFileSystem fileSystem = new POIFSFileSystem();
                        DirectoryEntry directory = fileSystem.getRoot();
                        directory.createDocument("WordDocument", byteArrayInputStream);
                        FileOutputStream fileOutputStream = new FileOutputStream(path);
                        fileSystem.writeFilesystem(fileOutputStream);
                        byteArrayInputStream.close();
                        fileOutputStream.close();
                        shareFile = new File(path);
                        fileSize=shareFile.length();
                        HttpHolder.upLoadFile(RequestConfig.UP_FILE,path, new HttpCallBack("upload"));
                    } catch (IOException e) {
                        Log.e("TAG", e.getMessage());
                    }
                }
            }).setNegativeButton("取消",null).show();
//        }else{
//                if(type.equals("export")){
//                    Map<String,Object> map=new HashMap<>();
//                    map.put("header","X-Auth-Token");
//                    map.put("fileId",ocrInfo.getId());
//                    map.put("exportUser",Configs.USER_NAME + "_" + Configs.USER_ID);
//                    map.put("type",0);//0导出；2分享
//                    HttpHolder.createFileRecord(RequestConfig.EXPORT_CREATE_URL,map,new HttpCallBack(statusType));
//                }else if(type.equals("share")){
//                    HttpHolder.shareCcFile(ocrInfo,new HttpCallBack("share"));
//                }
//            }
        }

    public class HttpCallBack implements Callback.CommonCallback<String>{
        String httpType;
        public HttpCallBack(String type) {
            httpType=type;
        }
        @Override
        public void onSuccess(String result) {
            if("upload".equals(httpType)){
                try {
                    JSONObject object = new JSONObject(result);
                    String filePath = object.getString("message");
                    String fileName = editFilename;
                    if(fileName=="")
                        fileName=System.currentTimeMillis()+"";
                    String suffix="";
                    if(fileName.contains("txt"))
                        suffix="txt";
                    else if(fileName.contains("doc") || fileName.contains("docs"))
                        suffix="doc";
                    Map<String, Object> map = new HashMap<>();
                    map.put("header", filePath);
                    map.put("filePath", filePath);
                    map.put("fileName", fileName);
                    map.put("fileSuffix",suffix);
                    map.put("fileSource",sourceFilePath);
                    map.put("fileSourceThum",thumPath);
                    map.put("content",image.getRecogniztion());
                    map.put("fileType","ocr");
                    map.put("fileSize",fileSize);
                    map.put("uploadPeple", Configs.USER_NAME + "_" + Configs.USER_ID);
                    HttpHolder.exportFile(RequestConfig.ADD_URL, map, new HttpCallBack("create_file"));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }else if("create_file".equals(httpType)){
                ocrInfo = GsonUtil.getInstance().fromJson(result, new TypeToken<OcrInfo>() {
                }.getType());
                if(statusType.equals("0")){
                    Map<String,Object> map=new HashMap<>();
                    map.put("header","X-Auth-Token");
                    map.put("fileId",ocrInfo.getId());
                    map.put("exportUser",Configs.USER_NAME + "_" + Configs.USER_ID);
                    map.put("type",statusType);//0导出
                    HttpHolder.createFileRecord(RequestConfig.EXPORT_CREATE_URL,map,new HttpCallBack("export"));
                }else{
                    HttpHolder.shareCcFile(ocrInfo,new HttpCallBack("share"));
                }
               }else if("export".equals(httpType)){
                if(dialog!=null && dialog.isShowing())
                    dialog.dismiss();
                ExportInfo exportInfo= GsonUtil.getInstance().fromJson(result, new TypeToken<ExportInfo>() {
                }.getType());
                if(null!=exportInfo){
                    Toast.makeText(VertifyActivity.this,"导出成功",Toast.LENGTH_SHORT).show();
                }
            }else if ("share".equals(httpType)){
                ShareInfo shareInfo= GsonUtil.getInstance().fromJson(result, new TypeToken<ShareInfo>() {
                }.getType());
                if(null==shareInfo){
                    Toast.makeText(VertifyActivity.this,"分享记录提交失败，请重新尝试",Toast.LENGTH_SHORT).show();
                }else{
                    boolean isf=shareFile.exists();
                    ShareUtil.shareFile(VertifyActivity.this,shareFile);
                }
            }
        }

        @Override
        public void onError(Throwable ex, boolean isOnCallback) {
            Log.e("TAG",ex.toString());
            Toast.makeText(VertifyActivity.this, "连接异常，请调试", Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onCancelled(CancelledException cex) {

        }

        @Override
        public void onFinished() {

        }
    }


}
