package cn.com.bril.androidocr.studio.ui.activity;

import android.Manifest;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.bril.baoding.studio.aidl.GetUserid;
import com.scanlibrary.ScanConstants;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import cn.com.bril.androidocr.studio.OcrApplication;
import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.configs.Configs;
import cn.com.bril.androidocr.studio.interf.HandleMenuListener;
import cn.com.bril.androidocr.studio.ui.adapter.TabFragmentPagerAdapter;
import cn.com.bril.androidocr.studio.ui.fragment.ExportFragment;
import cn.com.bril.androidocr.studio.ui.fragment.ShareFragment;
import cn.com.bril.androidocr.studio.ui.widget.NoScrollViewPager;
import cn.com.bril.androidocr.studio.utils.FileUtil;
import cn.com.bril.androidocr.studio.utils.ScreenUtil;
import cn.com.bril.androidocr.studio.utils.ViewUtil;

import static cn.com.bril.androidocr.studio.configs.RequestConfig.PERMISSION_REQUEST_CODE;

public class MainActivity extends BaseActivity implements View.OnClickListener, HandleMenuListener, ExportFragment.NoticeMessageToMain {


    @BindView(R.id.layout_1)
    LinearLayout layout1;
    @BindView(R.id.layout_2)
    LinearLayout layout2;
    @BindView(R.id.layout_3)
    LinearLayout layout3;
    @BindView(R.id.viewPager)
    NoScrollViewPager viewPager;
    @BindView(R.id.num)
    TextView num;
    @BindView(R.id.tab_select)
    TextView tabSelect;
    @BindView(R.id.export)
    TextView export;
    @BindView(R.id.share)
    TextView share;
    @BindView(R.id.rename)
    TextView rename;
    @BindView(R.id.delete)
    TextView delete;
    @BindView(R.id.bottom_menu)
    RelativeLayout bottomMenu;
    @BindView(R.id.left_iv)
    LinearLayout leftIv;
    @BindView(R.id.tab_back)
    ImageView tabBack;
    //    @BindView(R.id.tab_head)
//    RelativeLayout tabHeader;
    @BindView(R.id.topBarLayout)
    RelativeLayout topBarLayout;
    @BindView(R.id.tab_head)
    RelativeLayout tabHead;
    @BindView(R.id.head_content)
    RelativeLayout headContent;
    @BindView(R.id.main_bottom_menu)
    LinearLayout mainBottomMenu;
    @BindView(R.id.tab_bottom)
    LinearLayout tabBottom;
    @BindView(R.id.right_iv)
    ImageView rightIv;
    private String picPath;
    @NonNull
    @BindView(R.id.rightTv)
    TextView rightTv;
    @BindView(R.id.fabbtn)
    FloatingActionButton fabbtn;
    @BindView(R.id.topTitle)
    TextView topTitle;
    @BindView(R.id.left_tv)
    TextView leftTv;
    @BindView(R.id.group)
    RadioGroup group;

    private int type;//获取图片类型
    private GetUserid mService;
    private List<Fragment> fragmentList;
    private ServiceConnection mServiceConnection = new ServiceConnection() {
        @Override
        public void onServiceDisconnected(ComponentName arg0) {
            mService = null;
        }
        @Override
        public void onServiceConnected(ComponentName arg0, IBinder arg1) {
            mService = GetUserid.Stub.asInterface(arg1);
            try {
                Configs.USER_ID = mService.getUserid() + "";
                Configs.USER_NAME = mService.getUsername();
                Log.e("TAG", Configs.USER_ID+";"+ Configs.USER_NAME );

            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    };
    private AlertDialog dialog;
    private ExportFragment exportFragment;
    private ShareFragment shareFragment;
    private TabFragmentPagerAdapter adapter;
    private boolean isAllSelected = false;
    private PopupWindow rightMenuWindow;
    int selectedCount=0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);
        ButterKnife.bind(this);
        OcrApplication.getInstance().addActivity(this);

        bindService();

        initViews();

        setIconSize();

        initEvents();

        initPermission();

        dialog = new ProgressDialog(this);

        FileUtil.creatDir(Configs.WORD_BASE);
        FileUtil.creatDir(Configs.TXT_BASE);
        FileUtil.creatDir(Configs.IMAGE_BASE);
    }

    private void bindService() {
        Intent intent = new Intent("com.xtpro.studio.service.AIDLService");
        intent.setPackage("com.bril.baoding.studio");
        bindService(intent, mServiceConnection, Context.BIND_AUTO_CREATE);
    }

    private void initPermission() {
        String permissions[] = {
                Manifest.permission.READ_EXTERNAL_STORAGE,
                Manifest.permission.WRITE_EXTERNAL_STORAGE,
                Manifest.permission.CAMERA
        };
        ArrayList<String> toApplyList = new ArrayList<String>();
        for (String perm : permissions) {
            if (PackageManager.PERMISSION_GRANTED != ContextCompat.checkSelfPermission(this, perm)) {
                toApplyList.add(perm);
                //进入到这里代表没有权限.
            }
        }
        String tmpList[] = new String[toApplyList.size()];
        if (!toApplyList.isEmpty()) {
            ActivityCompat.requestPermissions(this, toApplyList.toArray(tmpList), PERMISSION_REQUEST_CODE);
        }
    }


    private void initViews() {
        rightIv.setVisibility(View.VISIBLE);
        rightTv.setVisibility(View.GONE);
        topTitle.setText("OCR识别");
        fragmentList = new ArrayList<>();
        if (exportFragment == null)
            exportFragment = new ExportFragment();
        if (shareFragment == null)
            shareFragment = new ShareFragment();
        fragmentList.add(exportFragment);
        fragmentList.add(shareFragment);
        adapter = new TabFragmentPagerAdapter(getSupportFragmentManager(), fragmentList);
        viewPager.setAdapter(adapter);

    }

    public void setIconSize() {

        //设置bottom icon 大小
//        ViewUtil.setNavImageSize(this, export, R.drawable.export, 55, 55);//40
        ViewUtil.setNavImageSize(this, share, R.drawable.share_focused, 40, 45);//40
//        ViewUtil.setNavImageSize(this, rename, R.drawable.rename, 50, 50);//40
        ViewUtil.setNavImageSize(this, delete, R.drawable.delete_normal, 35, 45);//32
    }

    private void setImageGone() {

        layout1.setVisibility(View.GONE);
        layout2.setVisibility(View.INVISIBLE);
        layout3.setVisibility(View.INVISIBLE);
    }

    private void initEvents() {
        group.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, @IdRes int checkedId) {
                String tag = null;
                switch (checkedId) {
                    case R.id.radio_1:
                        tag = "生成记录";
                        break;
                    case R.id.radio_2:
                        tag = "导出记录";
                        setViewShow(0);
                        break;
                    case R.id.radio_3:
                        tag = "分享记录";
                        setViewShow(1);
                        break;
                }
                topTitle.setText(tag);
            }
        });
        export.setOnClickListener(this);
        share.setOnClickListener(this);
        delete.setOnClickListener(this);
        viewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                setViewShow(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if(requestCode==PERMISSION_REQUEST_CODE){
           for(int grant: grantResults){
               if(grant!=PackageManager.PERMISSION_GRANTED)
                   Toast.makeText(this,"文件或拍照权限未开启",Toast.LENGTH_SHORT).show();
           }
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    public void setViewShow(int position) {
        setImageGone();
        switch (position) {
            case 0:
                layout2.setVisibility(View.VISIBLE);
                break;
            case 1:
                layout3.setVisibility(View.VISIBLE);
                break;
        }
        viewPager.setCurrentItem(position);
    }

    @OnClick({R.id.right_iv, R.id.fabbtn, R.id.tab_select, R.id.tab_back,R.id.left_iv})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.rightTv:
                type = ScanConstants.OPEN_MEDIA;
                Intent intent = new Intent(this, RecognizeActivity.class);
                intent.putExtra("type", type);
                startActivity(intent);
                break;
            case R.id.right_iv:
                if(null== rightMenuWindow)
                    showHandleMenu();
                else if(rightMenuWindow !=null&&!rightMenuWindow.isShowing())
                    showHandleMenu();
                break;
            case R.id.fabbtn:
                type = ScanConstants.OPEN_CAMERA;
                Intent intent2 = new Intent(this, RecognizeActivity.class);
                intent2.putExtra("type", type);
                startActivity(intent2);
                break;
            case R.id.tab_back:
                setHandleMenu(View.GONE);
                adapter.notifyDataSetChanged();
                break;
            case R.id.tab_select://全选
                isAllSelected = !isAllSelected;
                if (isAllSelected)
                    tabSelect.setText("全不选");
                else
                    tabSelect.setText("全选");
                if (viewPager.getCurrentItem() == 0)
                    exportFragment.setAllItemChecked(isAllSelected);
                else
                    shareFragment.setAllItemChecked(isAllSelected);
                break;
            case R.id.left_iv:
                finish();
                break;
        }
    }
    //展示工具栏
    public void showHandleMenu() {
        View popupWindow = LayoutInflater.from(this).inflate(R.layout.main_menu_layout, null);
        rightMenuWindow = new PopupWindow(popupWindow, LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        popupWindow.findViewById(R.id.main_import).setOnClickListener(this);
        popupWindow.findViewById(R.id.main_search).setOnClickListener(this);
        rightMenuWindow.setTouchable(true);
        rightMenuWindow.setOutsideTouchable(true);
        rightMenuWindow.setBackgroundDrawable(new BitmapDrawable(getResources(), (Bitmap) null));
        int windowPos[] = ScreenUtil.calculatePopWindowPos(this, rightIv, popupWindow);
        int xoff=windowPos[0]-60;
        int wid=rightIv.getMeasuredWidth()-30;
        rightMenuWindow.showAtLocation(rightIv, Gravity.TOP|Gravity.LEFT,xoff,windowPos[1]);
//        rightMenuWindow.showAsDropDown(rightIv);
    }

    @Override
    public void onBackPressed() {
        if (tabBottom.getVisibility() == View.VISIBLE) {
            if (viewPager.getCurrentItem() == 0)
                exportFragment.setCheckBoxShow(View.GONE);
            else
                shareFragment.setCheckBoxShow(View.GONE);
            setHandleMenu(View.GONE);
        } else {
            OcrApplication.getInstance().exit();
            super.onBackPressed();
        }
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.share:
                if (selectedCount> 0) {
                    setHandleMenu(View.GONE);
                    if(viewPager.getCurrentItem()==0)
                        exportFragment.handleShareAction();
                    else
                        shareFragment.handleShareAction();
                } else
                    Toast.makeText(this, "请选择要分享的数据", Toast.LENGTH_SHORT).show();
                break;
            case R.id.delete:
                if (selectedCount > 0) {
                    setHandleMenu(View.GONE);
                    if(viewPager.getCurrentItem()==0)
                        exportFragment.handleDeleteAction();
                    else
                        shareFragment.handleDeletAction();
                } else
                    Toast.makeText(this, "请选择要删除的数据", Toast.LENGTH_SHORT).show();
                break;
            case R.id.main_import:
                type = ScanConstants.OPEN_MEDIA;
                Intent intent = new Intent(this, RecognizeActivity.class);
                intent.putExtra("type", type);
                startActivity(intent);
                rightMenuWindow.dismiss();
                break;
            case R.id.main_search:
                startActivity(new Intent(this, SearchActivity.class));
                rightMenuWindow.dismiss();
                break;
        }
    }

    @Override
    public void setHandleMenu(int v) {
        if (View.GONE == v) {
            tabHead.setVisibility(v);
            tabBottom.setVisibility(v);
            topBarLayout.setVisibility(View.VISIBLE);
            mainBottomMenu.setVisibility(View.VISIBLE);
            viewPager.setScanScroll(true);
//            adapter.notifyDataSetChanged();
        } else {
            tabHead.setVisibility(View.VISIBLE);
            tabBottom.setVisibility(View.VISIBLE);
            topBarLayout.setVisibility(View.GONE);
            mainBottomMenu.setVisibility(View.GONE);
            num.setText("已选择");
            viewPager.setScanScroll(false);
        }
    }

    @Override
    public void noticeMessage(int size) {
        selectedCount=size;
        num.setText("已选择" + size + "个");
    }

}
