package cn.com.bril.androidocr.studio.ui.activity;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;

import com.abbyy.mobile.ocr4.License;

import cn.com.bril.androidocr.studio.R;

public class BaseActivity extends AppCompatActivity {
    /** It is forbidden to redefine in child Activities dialog with dialogID = DIALOG_BAD_LICENSE */
    private static final int DIALOG_BAD_LICENSE = 100500;

    Toolbar toolbar;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(!License.isLoaded())
            dispatchBadLicense();
    }
    public void initTool(){
        if(toolbar!=null){
            toolbar.setTitle(getTitle());
            setSupportActionBar(toolbar);
            toolbar.setNavigationIcon(R.drawable.back_icon);
            toolbar.setNavigationOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    finish();
                }
            });
        }
    }

    @Override
    protected Dialog onCreateDialog(int id) {
        switch ( id ) {
            case DIALOG_BAD_LICENSE:
                return new AlertDialog.Builder( this )
                        .setCancelable( false )
                        .setTitle( getString( R.string.dialog_error ) )
                        .setMessage( getString( R.string.error_bad_license ) )
                        .setPositiveButton( getString( R.string.button_close ),
                                new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick( final DialogInterface dialog, final int id ) {
                                        BaseActivity.this.finish();
                                    }
                                } ).create();
            default:
                return super.onCreateDialog( id );
        }
    }
    private void dispatchBadLicense() {
        showDialog( BaseActivity.DIALOG_BAD_LICENSE );
    }


}
