package cn.com.bril.androidocr.studio.http;

import org.json.JSONArray;
import org.xutils.common.Callback;
import org.xutils.common.util.KeyValue;
import org.xutils.http.RequestParams;
import org.xutils.http.body.MultipartBody;
import org.xutils.x;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import cn.com.bril.androidocr.studio.beans.OcrInfo;
import cn.com.bril.androidocr.studio.beans.OcrRootBean;
import cn.com.bril.androidocr.studio.beans.ShareInfo;
import cn.com.bril.androidocr.studio.configs.Configs;
import cn.com.bril.androidocr.studio.configs.RequestConfig;
import cn.com.bril.androidocr.studio.interf.HttpFileCallBack;
import cn.com.bril.androidocr.studio.interf.OnHttpListener;
import cn.com.bril.androidocr.studio.ui.activity.VertifyActivity;
import cn.com.bril.androidocr.studio.utils.GsonUtil;

import static cn.com.bril.androidocr.studio.configs.RequestConfig.CREATE_FILE_URL;

/**
 * Created by sunny on 2018-3-12.
 */

public class HttpHolder {

    //add
    public static void exportFile(String url, Map<String,Object> map, VertifyActivity.HttpCallBack callBack){
        RequestParams params=new RequestParams(url);
        Iterator<Map.Entry<String,Object>> it = map.entrySet().iterator();
        while (it.hasNext()){
            Map.Entry<String,Object> entry = it.next();
            if(!"header".equals(entry.getKey()))
                params.addBodyParameter(entry.getKey(),String.valueOf(entry.getValue()));
            else
                params.addHeader("X-Auth-Token",String.valueOf(entry.getValue()));
        }
        x.http().post(params,callBack);
    }
    //上传文件
    public static void upLoadFile(String url,String path,Callback.CommonCallback callBack){
//        RequestParams params=new RequestParams(RequestConfig.UP_FILE);
        RequestParams params=new RequestParams(url);
        List<KeyValue> list = new ArrayList<>();
        list.add(new KeyValue("file", new File(path)));//文件流数据
//        list.add(new KeyValue("parameters", json.toString()));
        MultipartBody body = new MultipartBody(list, "UTF-8");
        //添加请求参数
        params.setRequestBody(body);
        x.http().post(params,callBack);
    }
    //创建记录
    public static void createFileRecord(String url,Map<String,Object> map,Callback.CommonCallback<String> listener){
        RequestParams params=new RequestParams(url);
        Iterator<Map.Entry<String,Object>> it = map.entrySet().iterator();
        while (it.hasNext()){
            Map.Entry<String,Object> entry = it.next();
            if(!"header".equals(entry.getKey()))
                params.addBodyParameter(entry.getKey(),String.valueOf(entry.getValue()));
            else
                params.addHeader("X-Auth-Token",String.valueOf(entry.getValue()));
        }
        x.http().post(params,listener);

    }
    //批量导出
    public static void volumeExport(List<OcrRootBean.Superior> infos, final OnHttpListener http){
        RequestParams params=new RequestParams(RequestConfig.BATCH_EXPORT_URL);
        params.addHeader("X-Auth-Token","ocr");
        String json=  GsonUtil.getInstance().toJson(infos);
        params.addBodyParameter("params",json);
        x.http().post(params, new Callback.CommonCallback<String>() {
            @Override
            public void onSuccess(String result) {
                http.success("",result);
            }
            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
                http.error("",ex);
            }
            @Override
            public void onCancelled(CancelledException cex) {
            }
            @Override
            public void onFinished() {
            }
        });
    }
    //批量删除导出记录
    public static void volumeDelete(final List<OcrRootBean.Superior> list, final OnHttpListener listener){
        JSONArray array= new JSONArray();
        for(int i=0;i<list.size();i++)
           array.put(list.get(i).getId());
        RequestParams params=new RequestParams(RequestConfig.BATCH_DELETE_URL);
        params.addBodyParameter("ids",array.toString());

        x.http().post(params, new Callback.CommonCallback<String>() {
            @Override
            public void onSuccess(String result) {
                listener.success("delete",result);
            }
            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
                listener.error("",ex);
            }
            @Override
            public void onCancelled(CancelledException cex) {
            }
            @Override
            public void onFinished() {
            }
        });
    }
    //单个下载
    public static void downLoad(Map<String,String> map, HttpFileCallBack callBack){
        RequestParams params=new RequestParams(RequestConfig.DOWN_LOAD_URL);
        Iterator<Map.Entry<String,String>> it = map.entrySet().iterator();
        while (it.hasNext()){
            Map.Entry<String,String> entry = it.next();
            if(entry.getKey().equals("downloadName")){
               if(entry.getValue().contains("doc"))
                   params.setSaveFilePath(Configs.WORD_BASE+"/"+entry.getValue().substring(entry.getValue().lastIndexOf("/")+1));
                else if(entry.getValue().contains("jpg") ||entry.getValue().contains("png"))
                    params.setSaveFilePath(Configs.IMAGE_BASE+"/"+entry.getValue().substring(entry.getValue().lastIndexOf("/")+1));
            }
            params.addBodyParameter(entry.getKey(),String.valueOf(entry.getValue()));
        }
        x.http().get(params,callBack);
    }
    //分享单个文件
    public static void shareCcFile(OcrInfo info, VertifyActivity.HttpCallBack callBack){
        RequestParams params=new RequestParams(RequestConfig.SHARE_ALONE_URL);
        params.addHeader("X-Auth-Token","share");
        params.addBodyParameter("sharingPeple", Configs.USER_NAME+"_"+Configs.USER_ID);
        params.addBodyParameter("type","0");
        params.addBodyParameter("fileId",info.getId());
        params.addBodyParameter("fileName",info.getFileName());
        params.addBodyParameter("filePath",info.getFilePath());
        x.http().post(params,callBack);
    }
    //批量分享
    public static void batchShareCcFile(List<ShareInfo> infos, MainHttpCallBack callBack) {

        RequestParams params = new RequestParams(RequestConfig.BATCH_SHARE_URL);
        params.addHeader("X-Auth-Token", "share");
        params.addBodyParameter("params", GsonUtil.getInstance().toJson(infos));
        x.http().post(params, callBack);
    }
    //批量删除分享记录
    public static void batchDeleteShareRecord(List<ShareInfo> list,MainHttpCallBack callBack){
        RequestParams params=new RequestParams(RequestConfig.BATCH_DELETE_SHARE_URL);
        JSONArray array= new JSONArray();
        for(int i=0;i<list.size();i++)
            array.put(list.get(i).getId());
        params.addBodyParameter("ids",array.toString());
        x.http().post(params,callBack);
    }
    //批量创建文件
    public static void batchCreateFiles(List<OcrRootBean.Cc_file> files,MainHttpCallBack callBack){
        List<OcrRootBean.Cc_file> newFiles=new ArrayList<>();
        OcrRootBean.Cc_file cc_file;
        for(OcrRootBean.Cc_file file:files){
            cc_file=new OcrRootBean.Cc_file(file.getFileName(),file.getFilePath(),file.getFileSuffix(),file.getUploadPeple(),file.getFileType());
            newFiles.add(cc_file);
        }
        RequestParams params=new RequestParams(RequestConfig.BATCH_CREATE_FILE_URL);
        params.addHeader("X-Auth-Token","batch_create");
        params.addBodyParameter("params",GsonUtil.getInstance().toJson(newFiles));
        x.http().post(params,callBack);
    }
    //创建文件
    public static void newFileCreate(OcrRootBean.Cc_file cc_file,MainHttpCallBack callBack){

        RequestParams params=new RequestParams(CREATE_FILE_URL);
        params.addHeader("X-Auth-Token","new");
        params.addBodyParameter("fileName",cc_file.getFileName());
        params.addBodyParameter("filePath",cc_file.getFilePath());
        params.addBodyParameter("fileSuffix",cc_file.getFileSuffix());
        params.addBodyParameter("uploadPeple",Configs.USER_NAME+"_"+Configs.USER_ID);
        params.addBodyParameter("fileType",cc_file.getFileType());
        x.http().post(params,callBack);
    }
    //编辑分享记录
    public static void editShareRecord(String id,String name,MainHttpCallBack callBack){
        String url=RequestConfig.SHARE_LIST_URL+"/"+id+"/edit";
        RequestParams params=new RequestParams(url);
        params.addHeader("X-Auth-Token","edit");
        params.addBodyParameter("fileName",name);
        x.http().post(params,callBack);
    }

}
