package tentop.com.cn.pulltorefreshlib;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AbsListView.OnScrollListener;
import android.widget.Adapter;
import android.widget.ListView;


public class PullToRefreshListView extends PullToRefreshBase<ListView> implements OnScrollListener
{
	private static int id = 1;
	
	private ListViewScrollStateChanged stateChanged;
	
	private ListView mListView;
	
	private LoadingLayout mLoadMoreFooterLayout;
	
	private OnScrollListener mScrollListener;

	
	public PullToRefreshListView(Context context)
	{
		this(context, null);
	}

	
	public PullToRefreshListView(Context context, AttributeSet attrs)
	{
		this(context, attrs, 0);
	}

	
	public PullToRefreshListView(Context context, AttributeSet attrs, int defStyle)
	{
		super(context, attrs);
		setPullLoadEnabled(false);
	}

	@Override
	protected ListView createRefreshableView(Context context, AttributeSet attrs)
	{
		ListView listView = new ListView(context, attrs);
		listView.setId(id == 5 ? 1 : id++);
		mListView = listView;
		listView.setOnScrollListener(this);

		return listView;
	}

	
	public void setHasMoreData(boolean hasMoreData)
	{
		if (!hasMoreData)
		{
			if (null != mLoadMoreFooterLayout)
			{
				mLoadMoreFooterLayout.setState(ILoadingLayout.State.NO_MORE_DATA);
			}

			LoadingLayout footerLoadingLayout = getFooterLoadingLayout();
			if (null != footerLoadingLayout)
			{
				footerLoadingLayout.setState(ILoadingLayout.State.NO_MORE_DATA);
			}
		}
	}

	
	public void setOnScrollListener(OnScrollListener l)
	{
		mScrollListener = l;
	}

	
	public void setListViewScrollStateCallBack(ListViewScrollStateChanged changed)
	{
		this.stateChanged = changed;
	}

	@Override
	protected boolean isReadyForPullUp()
	{
		return isLastItemVisible();
	}

	@Override
	protected boolean isReadyForPullDown()
	{
		return isFirstItemVisible();
	}

	@Override
	protected void startLoading()
	{
		super.startLoading();

		if (null != mLoadMoreFooterLayout)
		{
			mLoadMoreFooterLayout.setState(ILoadingLayout.State.REFRESHING);
		}
	}

	@Override
	public void onPullUpRefreshComplete()
	{
		super.onPullUpRefreshComplete();

		if (null != mLoadMoreFooterLayout)
		{
			mLoadMoreFooterLayout.setState(ILoadingLayout.State.RESET);
		}
	}

	@Override
	public void setScrollLoadEnabled(boolean scrollLoadEnabled)
	{
		super.setScrollLoadEnabled(scrollLoadEnabled);

		if (scrollLoadEnabled)
		{
			// 设置Footer
			if (null == mLoadMoreFooterLayout)
			{
				mLoadMoreFooterLayout = new FooterLoadingLayout(getContext());
				mListView.addFooterView(mLoadMoreFooterLayout, null, false);
			}

			// if (null == mLoadMoreFooterLayout.getParent()) {
			// mListView.addFooterView(mLoadMoreFooterLayout, null, false);
			// }
			mLoadMoreFooterLayout.show(true);
		}
		else
		{
			if (null != mLoadMoreFooterLayout)
			{
				mLoadMoreFooterLayout.show(false);
			}
		}
	}

	@Override
	public LoadingLayout getFooterLoadingLayout()
	{
		if (isScrollLoadEnabled())
		{
			return mLoadMoreFooterLayout;
		}

		return super.getFooterLoadingLayout();
	}

	@Override
	public void onScrollStateChanged(AbsListView view, int scrollState)
	{
		if (stateChanged != null)
			stateChanged.nowState(scrollState);

		if (isScrollLoadEnabled() && hasMoreData())
		{
			if (scrollState == OnScrollListener.SCROLL_STATE_IDLE || scrollState == OnScrollListener.SCROLL_STATE_FLING)
			{
				if (isReadyForPullUp())
				{
					startLoading();
				}
			}
		}

		if (null != mScrollListener)
		{
			mScrollListener.onScrollStateChanged(view, scrollState);
		}
	}

	@Override
	public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount)
	{
		if (null != mScrollListener)
		{
			mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
		}
	}

	@Override
	protected LoadingLayout createHeaderLoadingLayout(Context context, AttributeSet attrs)
	{
		return new HeaderLoadingLayout(context);
		// if (VERSION.SDK_INT >= VERSION_CODES.GINGERBREAD) {
		// return new RotateLoadingLayout(context);
		// } else {
		// return new HeaderLoadingLayout(context);
		// }
	}

	
	private boolean hasMoreData()
	{
		if ((null != mLoadMoreFooterLayout) && (mLoadMoreFooterLayout.getState() == ILoadingLayout.State.NO_MORE_DATA))
		{
			return false;
		}

		return true;
	}

	
	private boolean isFirstItemVisible()
	{
		final Adapter adapter = mListView.getAdapter();

		if (null == adapter || adapter.isEmpty())
		{
			return true;
		}

		int mostTop = (mListView.getChildCount() > 0) ? mListView.getChildAt(0).getTop() : 0;
		if (mostTop >= 0)
		{
			return true;
		}

		return false;
	}

	
	private boolean isLastItemVisible()
	{
		final Adapter adapter = mListView.getAdapter();

		if (null == adapter || adapter.isEmpty())
		{
			return true;
		}

		final int lastItemPosition = adapter.getCount() - 1;
		final int lastVisiblePosition = mListView.getLastVisiblePosition();

		
		if (lastVisiblePosition >= lastItemPosition - 1)
		{
			final int childIndex = lastVisiblePosition - mListView.getFirstVisiblePosition();
			final int childCount = mListView.getChildCount();
			final int index = Math.min(childIndex, childCount - 1);
			final View lastVisibleChild = mListView.getChildAt(index);
			if (lastVisibleChild != null)
			{
				return lastVisibleChild.getBottom() <= mListView.getBottom();
			}
		}

		return false;
	}

}
