package bril.com.cn.progressdemo;

import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.view.View;

import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Main2Activity extends AppCompatActivity implements View.OnClickListener {

    private final String PATH = Environment
            .getExternalStorageDirectory().getPath() + "/documentocr/docs";
    private static final String TAG = "WordExtractor";
    private String content;
    private String txtPath;
    private static final String[] BASE_TAGS = { "${name}", "${time}", "${content}"};


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main2);

        findViewById(R.id.btn).setOnClickListener(this);

        content=getResources().getString(R.string.content);

//        AssetUtil.CopyAssets(this,"file:///android_asset",PATH);
        AssetUtil.copyFile(this, "demo.docx",PATH);

    }

    @Override
    public void onClick(View v) {
        switch (v.getId()){
            case R.id.btn:
//                exportTxt();
                 int flg= exportDoc(PATH+"/csk.doc","检务通识别文件\n"+content);
                if(flg==1)
                    reWriteWord(PATH+"/csk.doc");
//                exportWordModule();
//                PoiUtil.exportWord(this,PATH+"/csk.doc",content);
                break;



        }
    }
    private void exportTxt(){

        txtPath= PATH+"/"+"test.txt";
        File file;
        try {
            if(!new File(PATH).exists())
                new File(PATH).mkdirs();
            file=new File(txtPath);
            if(file.exists())
                file.delete();
            file.createNewFile();
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(content.getBytes());
            outStream.close();
            handler.sendEmptyMessage(0);
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    private Handler handler=new Handler(){
        @Override
        public void handleMessage(Message msg) {
            if(msg.what==0){
                exportToWord();
            }
        }
    };
    public void exportToWord(){
        try {
            InputStream is = new FileInputStream(txtPath);

            HWPFDocument doc = new HWPFDocument(is);
            //获取Range
            Range range = doc.getRange();
            for(int i = 0; i < 100; i++) {
                if( i % 2 == 0 ) {
                    range.insertAfter("Hello " + i + "\n");//在文件末尾插入String
                } else {
                    range.insertBefore("      Bye " + i + "\n");//在文件头插入String
                }
            }
            //写到原文件中
            File file=new File(PATH+"/"+"test.doc");
            if(file.exists())
                file.delete();
            file.createNewFile();
            OutputStream os = new FileOutputStream(file);
            doc.write(os);
            is.close();
            os.close();

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int exportDoc(String destFile,String fileContent){
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileContent.getBytes("GB2312"));
            POIFSFileSystem fileSystem = new POIFSFileSystem();
            DirectoryEntry directory = fileSystem.getRoot();
            directory.createDocument("WordDocument", byteArrayInputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(destFile);
            fileSystem.writeFilesystem(fileOutputStream);
            byteArrayInputStream.close();
            fileOutputStream.close();
            return 1;
        } catch (IOException e) {return 0;
        }
    }
    public void reWriteWord(String path){
        //写字符串进word
        InputStream is = null;
        try {
            File file=new File(path);
            boolean flg=file.exists();
            is = new FileInputStream(path);
            HWPFDocument doc = new HWPFDocument(is);
            //获取Range
            Range range = doc.getRange();
            for(int i = 0; i < 100; i++) {
                if( i % 2 == 0 ) {
                    range.insertAfter("Hello " + i + "\n");//在文件末尾插入String
                } else {
                    range.insertBefore("      Bye " + i + "\n");//在文件头插入String
                }
            }
            //写到原文件中
            OutputStream os = new FileOutputStream(path);
            //写到另一个文件中
            //OutputStream os = new FileOutputStream(其他路径);
            doc.write(os);
            is.close();
            os.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }


    }
    public void exportWordModule(){
        try {
            InputStream is = getAssets().open("demo.docx");
//            InputStream is = new FileInputStream(PATH+"/demo.docx");
//            POIFSFileSystem fileSystem=new POIFSFileSystem(new File(PATH+"/demo.docx"));

            HWPFDocument doc = new HWPFDocument(is);

            //获取Range
            Range range = doc.getRange();
            //把range范围内的${reportDate}替换为当前的日期
            range.replaceText("${time}", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            range.replaceText("${content}", content);
            range.replaceText("${name}", "检务办公");


//            for(int i = 0; i < 100; i++) {
//                if( i % 2 == 0 ) {
//                    range.insertAfter("Hello " + i + "\n");//在文件末尾插入String
//                } else {
//                    range.insertBefore("      Bye " + i + "\n");//在文件头插入String
//                }
//            }
            //写到另一个文件中
            String newdoc=PATH+"/"+System.currentTimeMillis()+".doc";
            new File(newdoc).createNewFile();
            OutputStream os = new FileOutputStream(newdoc);
            doc.write(os);
            is.close();
            os.close();

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
