package cn.com.bril.androidocr.studio.ui.fragment;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.Toast;

import com.google.gson.reflect.TypeToken;

import org.xutils.common.Callback;
import org.xutils.http.RequestParams;
import org.xutils.x;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.OcrRootBean;
import cn.com.bril.androidocr.studio.configs.Configs;
import cn.com.bril.androidocr.studio.configs.RequestConfig;
import cn.com.bril.androidocr.studio.interf.HandleMenuListener;
import cn.com.bril.androidocr.studio.ui.adapter.FragmentListAdapter;
import cn.com.bril.androidocr.studio.ui.pulltorefresh.PullToRefreshBase;
import cn.com.bril.androidocr.studio.ui.pulltorefresh.PullToRefreshListView;
import cn.com.bril.androidocr.studio.utils.FileUtil;
import cn.com.bril.androidocr.studio.utils.GsonUtil;
import cn.com.bril.androidocr.studio.utils.HttpUtil;
import cn.com.bril.androidocr.studio.utils.IntentUtil;

/**
 * Created by sunny on 2018-3-12.
 */

public class ShareFragment extends Fragment {


    private PullToRefreshListView pullToRefreshListView;
    private ListView listView;
    private Context context;
    private FragmentListAdapter adaper;
    private List<OcrRootBean> beanList=new ArrayList<>();
    private boolean isUpdate=false,hasMoreData=false;
    private int page=1,pageSize=10;
    private FragmentListAdapter.ListTextClickListener listTextClickListener;
    private List<OcrRootBean> selectedInfos=new ArrayList<>();
    private ExportFragment.NoticeMessageToMain messageToMain;
    private HandleMenuListener handleMenuListener;
    private ProgressDialog dialog;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.context=context;
        listTextClickListener=(FragmentListAdapter.ListTextClickListener)context;
        handleMenuListener= (HandleMenuListener) context;
        messageToMain= (ExportFragment.NoticeMessageToMain) context;

    }

    public List<OcrRootBean> getSelectedInfos() {
        return selectedInfos;
    }

    public void setSelectedInfos(List<OcrRootBean> selectedInfos) {
        this.selectedInfos = selectedInfos;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        View view=inflater.inflate(R.layout.listview_layout,null);

        initViews(view);

        initEvents();

        dialog=new ProgressDialog(context);

        return view;
    }

    public void initViews(View view){

        pullToRefreshListView= (PullToRefreshListView) view.findViewById(R.id.pullrefreshView);
        listView=pullToRefreshListView.getRefreshableView();
        pullToRefreshListView.doPullRefreshing(true,500);
        adaper=new FragmentListAdapter(context, beanList, listTextClickListener, new FragmentListAdapter.AdapterRadioSelectedListener() {
            @Override
            public void adapterRadioSelectedCallBack() {
                setSelectedInfos(adaper.getSelectedInfo());
                messageToMain.noticeMessage(adaper.getSelectedInfo());
            }
        });
        listView.setAdapter(adaper);
    }
    public void initEvents(){

        pullToRefreshListView.setOnRefreshListener(new PullToRefreshBase.OnRefreshListener<ListView>() {
            @Override
            public void onPullDownToRefresh(PullToRefreshBase<ListView> refreshView) {
                isUpdate=true;
                hasMoreData=true;
                page=1;
                if(HttpUtil.isNetworkConnected(context))
                    getShareRecord();
                else{
                    Toast.makeText(context,"暂无网络连接",Toast.LENGTH_LONG).show();
                    refreshView.onPullDownRefreshComplete();
                }
            }

            @Override
            public void onPullUpToRefresh(PullToRefreshBase<ListView> refreshView) {
                isUpdate=false;
                page++;
                if(HttpUtil.isNetworkConnected(context))
                    getShareRecord();
                else{
                    Toast.makeText(context,"暂无网络连接",Toast.LENGTH_LONG).show();
                    refreshView.onPullDownRefreshComplete();
                }
            }
        });
        listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener() {
            @Override
            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
                handleMenuListener.setHandleMenu(View.VISIBLE);
                adaper.setRadioShow(View.VISIBLE);
                return true;
            }
        });
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                String path=beanList.get(position).getIncludes().getCc_file().getFilePath();
                String fileName=beanList.get(position).getIncludes().getCc_file().getFileName();
                if(fileName.contains(".pdf")){
                    if(FileUtil.isFileExist(Configs.PDF_BASE+"/"+fileName))
                        startFileIntent("pdf",fileName);
                    else{
                        downLoadFile(path, fileName);
                    }
                }else if(fileName.contains(".doc")|| fileName.contains(".docs")){
                    if(FileUtil.isFileExist(Configs.WORD_BASE+"/"+fileName))
                        startFileIntent("word",fileName);
                    else
                        downLoadFile(path, fileName);
                }else if(fileName.contains(".txt")){
                    if(FileUtil.isFileExist(Configs.TXT_BASE+"/"+fileName))
                        startFileIntent("txt",fileName);
                    else
                        downLoadFile(path, fileName);
                }
            }
        });
    }

    public void setAllItemChecked(boolean flg){
        adaper.setRadioAllSelected(flg);
    }
    public void setCheckBoxShow(int v){
        adaper.setRadioShow(v);
    }

    private void getShareRecord(){

        RequestParams params=new RequestParams(RequestConfig.EXPORT_RECORD_URL);
        params.addBodyParameter("page",page+"");
        params.addBodyParameter("sortItem","create_time");
        params.addBodyParameter("sortOrder","desc");
        String userInfo= Configs.USER_NAME+"_"+Configs.USER_ID;
        String json="{\"cc_export_record\":{\"export_user\":{\"equalTo\":\""+userInfo+"\"},\"type\":{\"equalTo\":2}}}";
        params.addBodyParameter("filters",json);
        String json2="{\"cc_file\":{\"includes\":[\"file_id\"]}}";
        params.addBodyParameter("includes",json2);
        x.http().post(params, new Callback.CommonCallback<String>() {
            @Override
            public void onSuccess(String result) {
                List<OcrRootBean> been=GsonUtil.getInstance().fromJson(result,new TypeToken<List<OcrRootBean>>(){}.getType());
                if(isUpdate){
                    beanList.clear();
                }
                beanList.addAll(been);
                if(been.size()==0){
                    Toast.makeText(context,"暂无数据",Toast.LENGTH_SHORT).show();
                }
                else if(been.size()<10&& been.size()>0){
                    hasMoreData=false;
//                    Toast.makeText(context,"无更多数据",Toast.LENGTH_SHORT).show();
                }
                else
                    hasMoreData=true;
                adaper.notifyDataSetChanged();

                pullToRefreshListView.onPullUpRefreshComplete();
                pullToRefreshListView.onPullDownRefreshComplete();
                pullToRefreshListView.setHasMoreData(hasMoreData);
            }
            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
                pullToRefreshListView.onPullUpRefreshComplete();
                pullToRefreshListView.onPullDownRefreshComplete();
            }
            @Override
            public void onCancelled(CancelledException cex) {
            }
            @Override
            public void onFinished() {
            }
        });
    }

    private void downLoadFile(String path, String fileName) {
        dialog.setMessage("正在下載...");
        dialog.show();
        RequestParams params=new RequestParams(RequestConfig.DOWN_LOAD_URL);
        params.addBodyParameter("fileName",path);
        params.addBodyParameter("downloadName",fileName);
        params.setSaveFilePath(Configs.WORD_BASE+"/"+fileName);
        x.http().get(params, new Callback.CommonCallback<File>() {
            @Override
            public void onSuccess(File result) {
                Toast.makeText(context,"下载成功", Toast.LENGTH_SHORT).show();
            }
            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
            }
            @Override
            public void onCancelled(CancelledException cex) {
            }
            @Override
            public void onFinished() {
            }
        });
    }
    private void startFileIntent(String type,String path){

        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        File file;
        Uri uri;
        if("word".equals(type)){
            file= new File(Configs.WORD_BASE+"/"+path);
            uri= Uri.fromFile(file);
            intent.setDataAndType(uri, "application/msword");
        }else if("pdf".equals(type)){
            file= new File(Configs.PDF_BASE+"/"+path);
            uri= Uri.fromFile(file);
            intent.setDataAndType(uri, "application/pdf");
        }else if("txt".equals(type)){
            file= new File(Configs.TXT_BASE+"/"+path);
            uri= Uri.fromFile(file);
            intent.setDataAndType(uri, "text/plain");
        }
        if(IntentUtil.isIntentAvailable(context,intent))
            startActivity(intent);
        else
            Toast.makeText(context,"请检测是否已安装相应的文件打开工具",Toast.LENGTH_SHORT).show();
    }
}
