package cn.com.bril.androidocr.studio.ui.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.util.List;

import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.OcrInfo;

/**
 * Created by sunny on 2018-3-16.
 */

public class OcrListAdaper extends RecyclerView.Adapter<OcrListAdaper.ViewHolder> implements View.OnClickListener {

    private Context context;
    private List<OcrInfo> infos;
    private OnItemClickListener callback;

    public OcrListAdaper(Context context, List<OcrInfo> list, OnItemClickListener listener) {
        this.context=context;
        infos=list;
    }
    private void setItemOnclick(OnItemClickListener listener){
        callback=listener;
    }
    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolder holder = new ViewHolder(LayoutInflater.from(context).inflate(R.layout.listview_item_layout, parent, false));
        holder.itemView.setOnClickListener(this);
        return holder;
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {

        OcrInfo info=infos.get(position);
        holder.time.setText(info.getLastUpdateTime());
        holder.title.setText(info.getFileName());

        holder.itemView.setTag(position);

    }

    @Override
    public int getItemCount() {
        return infos.size();
    }

    @Override
    public void onClick(View v) {
        if(callback!=null){
            int position= (int) v.getTag();
            callback.onClick(v,position);
        }
    }

    static class ViewHolder extends RecyclerView.ViewHolder{

        TextView title,time;
        public ViewHolder(View itemView) {
            super(itemView);
            title= (TextView) itemView.findViewById(R.id.title);
            time= (TextView) itemView.findViewById(R.id.time);
        }
    }

    //item点击事件
    public interface OnItemClickListener{
        void onClick(View v, int position);
    }
}
