package cn.com.bril.androidocr.studio.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.OcrRootBean;

/**
 * Created by sunny on 2018-3-19.
 */

public class FragmentListAdapter extends BaseAdapter {

    private Context context;
    private List<OcrRootBean> infos;
    private ListTextClickListener listTextClickListener;
    private int show=View.GONE;
    AdapterRadioSelectedListener radioSelectedListener;
    public FragmentListAdapter(Context context, List<OcrRootBean> list, ListTextClickListener listTextClickListener, AdapterRadioSelectedListener radioSelectedListener) {
        this.context=context;
        this.infos=list;
        this.listTextClickListener=listTextClickListener;
        this.radioSelectedListener=radioSelectedListener;
    }

    public void setRadioShow(int show){
        this.show=show;
        notifyDataSetChanged();
    }
    public void setRadioAllSelected(boolean flg){
        for(OcrRootBean info:infos)
            info.getSuperior().setChecked(flg);
        notifyDataSetChanged();
    }
    public List<OcrRootBean> getSelectedInfo(){

        List<OcrRootBean> newInfos=new ArrayList<>();
        for(OcrRootBean info:infos){
            if(info.getSuperior().isChecked())
                newInfos.add(info);
        }
        return newInfos;
    }
    @Override
    public int getCount() {
        return infos.size();
    }

    @Override
    public Object getItem(int position) {
        return infos.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder holder;
        if(convertView==null){
            holder=new ViewHolder();
            convertView= LayoutInflater.from(context).inflate(R.layout.listview_item_layout,null);
            holder.title= (TextView)convertView .findViewById(R.id.title);
            holder.time= (TextView) convertView.findViewById(R.id.time);
            holder.radioButton= (CheckBox) convertView.findViewById(R.id.radio);
            convertView.setTag(holder);
        }else
            holder= (ViewHolder) convertView.getTag();

        final OcrRootBean info=infos.get(position);
        holder.time.setText(info.getSuperior().getCreateTime());
        String s=info.getIncludes().getCc_file().getFileName();
        String fileName;
        if(s.contains("."))
             fileName=s.substring(0,s.indexOf("."));
        else
            fileName=s;
        holder.title.setText(fileName);
        holder.title.setOnClickListener(new ListTextOnClickListener(position));
        holder.radioButton.setVisibility(show);
        holder.radioButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                info.getSuperior().setChecked(isChecked);
                radioSelectedListener.adapterRadioSelectedCallBack();
                notifyDataSetChanged();
            }
        });
        holder.radioButton.setChecked(info.getSuperior().isChecked());
        return convertView;
    }
     class ListTextOnClickListener implements View.OnClickListener{
        int position;
        public ListTextOnClickListener(int index) {
            position=index;
        }

        @Override
        public void onClick(View v) {
            listTextClickListener.onListTextCallBack(infos.get(position));
        }
    }

    public interface AdapterRadioSelectedListener{
        void adapterRadioSelectedCallBack();
    }

    public interface ListTextClickListener{
        void onListTextCallBack(OcrRootBean info);
    }
    class ViewHolder{
        TextView title,time;
        CheckBox radioButton;
    }
}
