package cn.com.bril.androidocr.studio.ui.activity;

import android.Manifest;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.abbyy.mobile.ocr4.layout.MocrPrebuiltLayoutInfo;
import com.bumptech.glide.Glide;
import com.scanlibrary.ScanActivity;
import com.scanlibrary.ScanConstants;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import cn.com.bril.androidocr.studio.OcrApplication;
import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.Image;
import cn.com.bril.androidocr.studio.configs.RequestConfig;
import cn.com.bril.androidocr.studio.engine.RecognitionContext;
import cn.com.bril.androidocr.studio.engine.RecognitionService;

import static cn.com.bril.androidocr.studio.utils.FileUtil.saveBitmap;

/**
 * Created by sunny on 2017-11-29.
 */

public class RecognizeActivity extends AppCompatActivity {

    private static final String KEY_IMAGE_URI = "com.abbyy.mobile.ocr4.IMAGE_URI";
    private static final int REQUEST_CODE_RECOGNITION_FINISHED = 0;
    @BindView(R.id.bottom_btn)
    LinearLayout bottomBtn;
    @BindView(R.id.bar)
    ProgressBar bar;
    @BindView(R.id.progress)
    TextView progress;
    @BindView(R.id.bottom_progress)
    RelativeLayout bottomProgress;
    private BroadcastReceiver _progressReceiver;
    private BroadcastReceiver _prebuiltWordsInfoReceiver;
    private BroadcastReceiver _rotationTypeDetectionReceiver;

    @BindView(R.id.topTitle)
    TextView topTitle;
    @BindView(R.id.rightTv)
    TextView rightTv;
    @BindView(R.id.bottom)
    LinearLayout bottom;
    @BindView(R.id.left_iv)
    ImageView lefIv;
    @BindView(R.id.contentIv)
    ImageView contentIv;
    @BindView(R.id.left_tv)
    TextView leftTv;
    Image image;

    int image_type;


    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.recognize_layout);
        OcrApplication.getInstance().addActivity(this);
        ButterKnife.bind(this);
        leftTv.setText("识别");
        rightTv.setVisibility(View.GONE);
        image_type=getIntentData();

        checkPermission();

    }

    public int getIntentData() {
        return  getIntent().getIntExtra("type",4);
    }

    public void setButtonEnable(boolean flg) {
        bottom.setClickable(flg);
    }

    public void jumpScan() {
        Intent intent = new Intent(this, ScanActivity.class);
        intent.putExtra(ScanConstants.OPEN_INTENT_PREFERENCE, image_type);//ScanConstants.OPEN_CAMERA
        startActivityForResult(intent, 99);
    }

    //加载权限
    public void checkPermission() {
        String[] permissions = new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE};
        List<String> mPermissionList = new ArrayList<>();
        mPermissionList.clear();
        for (int i = 0; i < permissions.length; i++) {
            if (ContextCompat.checkSelfPermission(this, permissions[i]) != PackageManager.PERMISSION_GRANTED) {
                mPermissionList.add(permissions[i]);
            }
        }
        if (mPermissionList.isEmpty()) {//未授予的权限为空，表示都授予了
            jumpScan();
        } else {//请求权限方法
            String[] needPermissions = mPermissionList.toArray(new String[mPermissionList.size()]);//将List转为数组
            ActivityCompat.requestPermissions(this, needPermissions, RequestConfig.PERMISSION_REQUEST_CODE);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == RequestConfig.PERMISSION_REQUEST_CODE) {

            if (grantResults[0] == PackageManager.PERMISSION_GRANTED && grantResults[1] == PackageManager.PERMISSION_GRANTED) {
                //拍照
//                takePhoto();
                jumpScan();
            } else
                Toast.makeText(this, "权限未开放", Toast.LENGTH_SHORT).show();
        }
    }



    @Override
    protected void onStart() {
        super.onStart();
        //进度监听
        _progressReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(final Context context, final Intent intent) {
                final int progress = intent.getIntExtra(RecognitionService.EXTRA_RECOGNITION_PROGRESS, 0);
                dispatchRecognitionProgress(progress);
            }
        };
        //识别监听
        _prebuiltWordsInfoReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(final Context context, final Intent intent) {
                final MocrPrebuiltLayoutInfo layoutInfo = (MocrPrebuiltLayoutInfo) intent.getSerializableExtra(RecognitionService.EXTRA_PREBUILT_WORDS_INFO);
//                _imagePreview.setPrebuiltLayoutInfo( layoutInfo );
            }
        };
        //方向监听
        _rotationTypeDetectionReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(final Context context, final Intent intent) {
//                _imagePreview.applyDetectedRotationType();
            }
        };

        registerReceiver(_progressReceiver,
                new IntentFilter(RecognitionService.ACTION_RECOGNITION_PROGRESS));

        registerReceiver(_prebuiltWordsInfoReceiver,
                new IntentFilter(RecognitionService.ACTION_PREBUILT_WORDS_INFO));

        registerReceiver(_rotationTypeDetectionReceiver,
                new IntentFilter(RecognitionService.ACTION_ROTATION_TYPE_DETECTED));
    }

    @Override
    protected void onStop() {
        super.onStop();
        //取消监听
        if (_progressReceiver != null) {
            unregisterReceiver(_progressReceiver);
        }
        if (_prebuiltWordsInfoReceiver != null) {
            unregisterReceiver(_prebuiltWordsInfoReceiver);
        }
        if (_rotationTypeDetectionReceiver != null) {
            unregisterReceiver(_rotationTypeDetectionReceiver);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        RecognitionContext.cancelGetImage();
        //取消识别
        if (isFinishing()) {
            stopRecognition();
        }
    }

    @OnClick({R.id.left_iv, R.id.bottom})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.left_iv:
                finish();
                break;
            case R.id.bottom://识别触发
                setRecogniztionView(View.VISIBLE);
                Uri uri = Uri.fromFile(new File(image.getPath()));
                startRecogniziton(uri);
                setButtonEnable(false);
                break;
        }
    }

    private void startRecogniziton(Uri path) {
        RecognitionContext.cleanupImage();
        RecognitionContext.setRecognitionTarget(RecognitionContext.RecognitionTarget.TEXT);

        final Intent resultIntent = new Intent().putExtra(RecognizeActivity.KEY_IMAGE_URI, path);
        final PendingIntent pendingResult =
                createPendingResult(RecognizeActivity.REQUEST_CODE_RECOGNITION_FINISHED, resultIntent,
                        PendingIntent.FLAG_ONE_SHOT);
        RecognitionService.start(getApplicationContext(), path, pendingResult);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case REQUEST_CODE_RECOGNITION_FINISHED:
                setButtonEnable(true);
                RecognitionService.stop(getApplicationContext());
                if (resultCode == Activity.RESULT_OK) {
                    final String result = data.getStringExtra(RecognitionService.EXTRA_RECOGNITION_RESULT);
                    dispatchRecognitionSucceeded(result);
                } else {
                    if (data.hasExtra(RecognitionService.EXTRA_THROWABLE_PROXY)) {
                        final String throwableClassName =
                                data.getStringExtra(RecognitionService.EXTRA_THROWABLE_CLASS);
                        final Exception throwableProxy =
                                (Exception) data
                                        .getSerializableExtra(RecognitionService.EXTRA_THROWABLE_PROXY);
                        Throwable t = null;
                        try {
                            t = (Throwable) Class.forName(throwableClassName)
                                    .getConstructor(String.class)
                                    .newInstance(throwableProxy.getMessage());
                            t.setStackTrace(throwableProxy.getStackTrace());
                        } catch (final ClassNotFoundException e) {
                        } catch (final NoSuchMethodException e) {
                        } catch (final InvocationTargetException e) {
                        } catch (final IllegalAccessException e) {
                        } catch (final InstantiationException e) {
                        }
                        if (t == null) {
                            t = throwableProxy;
                        }
                        dispatchRecognitionFailed(t);
                    } else {
                        dispatchRecognitionCancelled();
                    }
                }
                break;
            case 99:
                if(null ==data)
                    finish();
                else{
                    Uri uri = data.getExtras().getParcelable(ScanConstants.SCANNED_RESULT);
                    Bitmap bitmap = null;
                    try {
                        bitmap = MediaStore.Images.Media.getBitmap(getContentResolver(), uri);
                        getContentResolver().delete(uri, null, null);
                        //                iv.setImageBitmap(bitmap);
                        String path = saveBitmap(this, bitmap);
                        String name = path.substring(path.lastIndexOf("/") + 1);
                        image = new Image(path, name);

                        Glide.with(this).load(image.getPath()).into(contentIv);
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break;
            default:
                finish();
                break;
        }
    }

    //取消服务
    private void stopRecognition() {
        final Intent intent =
                new Intent(RecognitionService.ACTION_STOP_RECOGNITION).setPackage(getPackageName());
        sendBroadcast(intent);
        RecognitionService.stop(getApplicationContext());
    }

    //识别结果 -成功
    private void dispatchRecognitionSucceeded(final Object result) {

        if (result != null) {
            RecognitionContext.setRecognitionResult(result);
            Intent intent = new Intent(this, VertifyActivity.class);
//            image.setRecogniztion(getResources().getString(R.string.vertify_content));
            image.setRecogniztion(result.toString());
            intent.putExtra("image", image);
            startActivity(intent);
        } else {
            Toast.makeText(this, "No result.", Toast.LENGTH_LONG).show();
        }

        finish();
    }

    //识别结果 -失败
    void dispatchRecognitionFailed(final Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("dispatchRecognitionFailed() argument is null");
        }
//        Log.v( RecognizeActivity.TAG, "dispatchRecognitionFailed()", throwable );
        // TODO: Show error message in a dialog.
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.toString();
        }
        Toast.makeText(this, message, Toast.LENGTH_LONG).show();
        finish();
    }

    //cancel button 监听
    private void dispatchRecognitionCancelled() {
//        Log.v( RecognitionActivity.TAG, "dispatchRecognitionCancelled()" );
        finish();
    }

    private void dispatchRecognitionProgress(int progress) {
        bar.setProgress(progress);
        this.progress.setText("已识别："+progress+"%");
    }
    private void setRecogniztionView(int type){
        if(type==View.GONE){
            bottomProgress.setVisibility(type);
            bottomBtn.setVisibility(View.VISIBLE);
            bar.setProgress(0);
        }else{
            bottomBtn.setVisibility(View.GONE);
            bottomProgress.setVisibility(type);
        }

    }
}
