package cn.com.bril.androidocr.studio.ui.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import cn.com.bril.androidocr.studio.OcrApplication;
import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.Image;

public class ProofreadActivity extends AppCompatActivity {

    @BindView(R.id.left_iv)
    ImageView lefIv;
    @BindView(R.id.topTitle)
    TextView topTitle;
    @BindView(R.id.rightTv)
    TextView rightTv;
    @BindView(R.id.photo)
    ImageView photo;
    @BindView(R.id.content)
    EditText content;
    @BindView(R.id.left_tv)
    TextView leftTv;

    Image image;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_proofread);
        OcrApplication.getInstance().addActivity(this);
        ButterKnife.bind(this);
        image=getIntentData();
        Glide.with(this).load(image.getPath()).into(photo);
        content.setText(image.getRecogniztion());
//        lefIv.setVisibility(View.VISIBLE);
        leftTv.setText("校对");
        rightTv.setText("完成");
    }

    public Image getIntentData() {
        return (Image) getIntent().getSerializableExtra("image");
    }

    @OnClick({R.id.left_iv, R.id.rightTv})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.left_iv:
                finish();
                break;
            case R.id.rightTv:
//                startActivity(new Intent(this,MainActivity.class));
                image.setRecogniztion(content.getText().toString());
                Intent intent=new Intent();
                intent.putExtra("image",image);
                setResult(Activity.RESULT_OK,intent);
                finish();
                break;

        }
    }
}
