package cn.com.bril.androidocr.studio.ui.activity;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewPager;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.bril.baoding.studio.aidl.GetUserid;
import com.scanlibrary.ScanConstants;

import org.json.JSONException;
import org.json.JSONObject;
import org.xutils.http.RequestParams;
import org.xutils.x;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import cn.com.bril.androidocr.studio.OcrApplication;
import cn.com.bril.androidocr.studio.R;
import cn.com.bril.androidocr.studio.beans.OcrRootBean;
import cn.com.bril.androidocr.studio.configs.Configs;
import cn.com.bril.androidocr.studio.configs.RequestConfig;
import cn.com.bril.androidocr.studio.http.HttpHolder;
import cn.com.bril.androidocr.studio.http.MainHttpCallBack;
import cn.com.bril.androidocr.studio.interf.HandleMenuListener;
import cn.com.bril.androidocr.studio.interf.OnHttpListener;
import cn.com.bril.androidocr.studio.ui.adapter.FragmentListAdapter;
import cn.com.bril.androidocr.studio.ui.adapter.TabFragmentPagerAdapter;
import cn.com.bril.androidocr.studio.ui.fragment.ExportFragment;
import cn.com.bril.androidocr.studio.ui.fragment.ShareFragment;
import cn.com.bril.androidocr.studio.ui.widget.NoScrollViewPager;
import cn.com.bril.androidocr.studio.utils.CustomDialogUtils;
import cn.com.bril.androidocr.studio.utils.FileUtil;
import cn.com.bril.androidocr.studio.utils.ScreenUtil;
import cn.com.bril.androidocr.studio.utils.ViewUtil;

public class MainActivity extends BaseActivity implements FragmentListAdapter.ListTextClickListener, View.OnClickListener, HandleMenuListener, ExportFragment.NoticeMessageToMain, OnHttpListener {


    @BindView(R.id.layout_1)
    LinearLayout layout1;
    @BindView(R.id.layout_2)
    LinearLayout layout2;
    @BindView(R.id.layout_3)
    LinearLayout layout3;
    @BindView(R.id.viewPager)
    NoScrollViewPager viewPager;
    @BindView(R.id.num)
    TextView num;
    @BindView(R.id.tab_select)
    TextView tabSelect;
    @BindView(R.id.export)
    TextView export;
    @BindView(R.id.share)
    TextView share;
    @BindView(R.id.rename)
    TextView rename;
    @BindView(R.id.delete)
    TextView delete;
    @BindView(R.id.bottom_menu)
    RelativeLayout bottomMenu;
    @BindView(R.id.left_iv)
    ImageView leftIv;
    @BindView(R.id.tab_back)
    ImageView tabBack;
    //    @BindView(R.id.tab_head)
//    RelativeLayout tabHeader;
    @BindView(R.id.topBarLayout)
    RelativeLayout topBarLayout;
    @BindView(R.id.tab_head)
    RelativeLayout tabHead;
    @BindView(R.id.head_content)
    RelativeLayout headContent;
    @BindView(R.id.main_bottom_menu)
    LinearLayout mainBottomMenu;
    @BindView(R.id.tab_bottom)
    LinearLayout tabBottom;
    @BindView(R.id.right_iv)
    ImageView rightIv;
    private String picPath;
    @NonNull
    @BindView(R.id.rightTv)
    TextView rightTv;
    @BindView(R.id.fabbtn)
    FloatingActionButton fabbtn;
    @BindView(R.id.topTitle)
    TextView topTitle;
    @BindView(R.id.left_tv)
    TextView leftTv;
    @BindView(R.id.group)
    RadioGroup group;

    private int type;//获取图片类型
    private GetUserid mService;
    private boolean isTabMenuShow = false;
    private List<Fragment> fragmentList;
    private ServiceConnection mServiceConnection = new ServiceConnection() {

        @Override
        public void onServiceDisconnected(ComponentName arg0) {
            mService = null;
        }

        @Override
        public void onServiceConnected(ComponentName arg0, IBinder arg1) {
            mService = GetUserid.Stub.asInterface(arg1);
            try {
                Configs.USER_ID = mService.getUserid() + "";
                Configs.USER_NAME = mService.getUsername();

            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    };
    private AlertDialog dialog;
    private ExportFragment exportFragment;
    private ShareFragment shareFragment;
    private List<OcrRootBean> selectedInfos;
    private OcrRootBean clickedBean;
    private EditText reNameEdit;//更改文件名
    private TabFragmentPagerAdapter adapter;
    private boolean isAllSelected = false;
    private ArrayList<Uri> shareFileUris;
    private PopupWindow rightMenuWindow;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        ButterKnife.bind(this);
        OcrApplication.getInstance().addActivity(this);

//        bindService();

        initViews();

        setIconSize();

        initEvents();

        dialog = new ProgressDialog(this);
    }

    private void bindService() {
        Intent intent = new Intent("com.xtpro.studio.service.AIDLService");
        intent.setPackage("com.bril.baoding.studio");
        bindService(intent, mServiceConnection, Context.BIND_AUTO_CREATE);
    }

    private void initViews() {
        rightIv.setVisibility(View.VISIBLE);
        rightTv.setVisibility(View.GONE);
        topTitle.setText("OCR识别");
        fragmentList = new ArrayList<>();
        if (exportFragment == null)
            exportFragment = new ExportFragment();
        if (shareFragment == null)
            shareFragment = new ShareFragment();
        fragmentList.add(exportFragment);
        fragmentList.add(shareFragment);
        adapter = new TabFragmentPagerAdapter(getSupportFragmentManager(), fragmentList);
        viewPager.setAdapter(adapter);

    }





    public void setIconSize() {

        //设置bottom icon 大小
//        ViewUtil.setNavImageSize(this, export, R.drawable.export, 55, 55);//40
        ViewUtil.setNavImageSize(this, share, R.drawable.share_focused, 40, 45);//40
//        ViewUtil.setNavImageSize(this, rename, R.drawable.rename, 50, 50);//40
        ViewUtil.setNavImageSize(this, delete, R.drawable.delete_normal, 35, 45);//32

    }

    private void setImageGone() {

        layout1.setVisibility(View.GONE);
        layout2.setVisibility(View.INVISIBLE);
        layout3.setVisibility(View.INVISIBLE);
    }

    private void initEvents() {
        group.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, @IdRes int checkedId) {

                String tag = null;
                switch (checkedId) {
                    case R.id.radio_1:
                        tag = "生成记录";
                        break;
                    case R.id.radio_2:
                        tag = "导出记录";
                        setViewShow(0);
                        break;
                    case R.id.radio_3:
                        tag = "分享记录";
                        setViewShow(1);
                        break;
                }
                topTitle.setText(tag);
            }
        });
        export.setOnClickListener(this);
        share.setOnClickListener(this);
        delete.setOnClickListener(this);
        viewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                setViewShow(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    public void setViewShow(int position) {
        setImageGone();
        switch (position) {
            case 0:
                layout2.setVisibility(View.VISIBLE);
                break;
            case 1:
                layout3.setVisibility(View.VISIBLE);
                break;
        }
        viewPager.setCurrentItem(position);
    }

    @OnClick({R.id.right_iv, R.id.fabbtn, R.id.tab_select, R.id.tab_back})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.rightTv:
                type = ScanConstants.OPEN_MEDIA;
                Intent intent = new Intent(this, RecognizeActivity.class);
                intent.putExtra("type", type);
                startActivity(intent);
                break;
            case R.id.right_iv:
                if(null== rightMenuWindow)
                    showHandleMenu();
                else if(rightMenuWindow !=null&&!rightMenuWindow.isShowing())
                    showHandleMenu();
                break;
            case R.id.fabbtn:
                type = ScanConstants.OPEN_CAMERA;
                Intent intent2 = new Intent(this, RecognizeActivity.class);
                intent2.putExtra("type", type);
                startActivity(intent2);
                break;
            case R.id.tab_back:
                setHandleMenu(View.GONE);
                adapter.notifyDataSetChanged();
                break;
            case R.id.tab_select://全选
                isAllSelected = !isAllSelected;
                if (isAllSelected)
                    tabSelect.setText("全不选");
                else
                    tabSelect.setText("全选");
                if (viewPager.getCurrentItem() == 0)
                    exportFragment.setAllItemChecked(isAllSelected);
                else
                    shareFragment.setAllItemChecked(isAllSelected);
                break;
        }
    }
    //展示工具栏
    public void showHandleMenu() {
        View popupWindow = LayoutInflater.from(this).inflate(R.layout.main_menu_layout, null);
        rightMenuWindow = new PopupWindow(popupWindow, LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        popupWindow.findViewById(R.id.main_import).setOnClickListener(this);
        popupWindow.findViewById(R.id.main_search).setOnClickListener(this);
        rightMenuWindow.setTouchable(true);
        rightMenuWindow.setOutsideTouchable(true);
        rightMenuWindow.setBackgroundDrawable(new BitmapDrawable(getResources(), (Bitmap) null));
        int windowPos[] = ScreenUtil.calculatePopWindowPos(this, rightIv, popupWindow);
        int xoff=windowPos[0]-60;
        int wid=rightIv.getMeasuredWidth()-30;
        rightMenuWindow.showAtLocation(rightIv, Gravity.TOP|Gravity.LEFT,xoff,windowPos[1]);
//        rightMenuWindow.showAsDropDown(rightIv);
    }



    @Override
    public void onBackPressed() {
        if (tabBottom.getVisibility() == View.VISIBLE) {
            if (viewPager.getCurrentItem() == 0)
                exportFragment.setCheckBoxShow(View.GONE);
            else
                shareFragment.setCheckBoxShow(View.GONE);
            setHandleMenu(View.GONE);
        } else {
            OcrApplication.getInstance().exit();
            super.onBackPressed();
        }
    }

    @Override
    public void onListTextCallBack(OcrRootBean info) {
        clickedBean = info;
        View view = LayoutInflater.from(this).inflate(R.layout.rename_dialog_layout, null);
        view.findViewById(R.id.normal_name).setOnClickListener(this);
        view.findViewById(R.id.positive).setOnClickListener(this);
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setView(view);
        reNameEdit = (EditText) view.findViewById(R.id.edit);
        reNameEdit.setHint(info.getIncludes().getCc_file().getFileName());
        dialog = builder.create();
        dialog.show();
        CustomDialogUtils.setDialogSize(this, dialog);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.positive:
                reNameFile();
                dialog.dismiss();
                break;
            case R.id.normal_name:
                dialog.dismiss();
                break;
            case R.id.export:
                HttpHolder.volumeExport(reStatusList(0), this);
                break;
            case R.id.share:
                if (selectedInfos != null && selectedInfos.size() > 0) {
//                    Toast.makeText(this,"正在检测需下载文件，请稍等...",Toast.LENGTH_SHORT).show();

                    getNotLoadFilesAndLoad(selectedInfos);
                } else
                    Toast.makeText(this, "请选择要分享的数据", Toast.LENGTH_SHORT).show();
                break;
            case R.id.delete:
                if (selectedInfos != null && selectedInfos.size() > 0) {
                    setHandleMenu(View.GONE);
                    HttpHolder.volumeDelete(reStatusList(-1), this);
                } else
                    Toast.makeText(this, "请选择要删除的数据", Toast.LENGTH_SHORT).show();
                break;
            case R.id.main_import:
                type = ScanConstants.OPEN_MEDIA;
                Intent intent = new Intent(this, RecognizeActivity.class);
                intent.putExtra("type", type);
                startActivity(intent);
                rightMenuWindow.dismiss();
                break;
            case R.id.main_search:
                startActivity(new Intent(this, SearchActivity.class));
                rightMenuWindow.dismiss();
                break;
        }
    }

    public List<OcrRootBean.Superior> reStatusList(int type) {
        List<OcrRootBean.Superior> list = new ArrayList<>();
        for (OcrRootBean info : selectedInfos) {
            if (type != -1)
                info.getSuperior().setType(type);
            list.add(info.getSuperior());
        }
        return list;
    }

    private void reNameFile() {
        String url = RequestConfig.EDIT_FILE_URL + clickedBean.getSuperior().getFileId() + "/edit";
        RequestParams params = new RequestParams(url);
        params.addHeader("X-Auth-Token", "1");
        String lastName=clickedBean.getIncludes().getCc_file().getFileName();
        params.addBodyParameter("fileName", reNameEdit.getText().toString()+lastName.substring(lastName.indexOf(".")));
        //缺少修改人
        x.http().post(params, new MainHttpCallBack("edit", this));
    }

    @Override
    public void setHandleMenu(int v) {
        if (View.GONE == v) {
            tabHead.setVisibility(v);
            tabBottom.setVisibility(v);
            topBarLayout.setVisibility(View.VISIBLE);
            mainBottomMenu.setVisibility(View.VISIBLE);
            viewPager.setScanScroll(true);
            adapter.notifyDataSetChanged();
        } else {
            tabHead.setVisibility(View.VISIBLE);
            tabBottom.setVisibility(View.VISIBLE);
            topBarLayout.setVisibility(View.GONE);
            mainBottomMenu.setVisibility(View.GONE);
            num.setText("已选择");
            viewPager.setScanScroll(false);
        }
    }

    private void getNotLoadFilesAndLoad(List<OcrRootBean> list) {
        List<OcrRootBean> loadBeans = new ArrayList<>();
        shareFileUris = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            OcrRootBean.Cc_file cc_file = list.get(i).getIncludes().getCc_file();
            String type = cc_file.getFileName().substring(cc_file.getFileName().indexOf(".") + 1);
            String filePath = "";
            if ("doc".equals(type) || "docs".equals(type))
                filePath = Configs.WORD_BASE + "/" + cc_file.getFileName();
            else if ("txt".equals(type))
                filePath = Configs.TXT_BASE + "/" + cc_file.getFileName();
            else if ("pdf".equals(type))
                filePath = Configs.PDF_BASE + "/" + cc_file.getFileName();
            shareFileUris.add(Uri.parse(filePath));
            if (!FileUtil.isFileExist(filePath))
                loadBeans.add(selectedInfos.get(i));
        }

        if (loadBeans.size() != 0) {
            dialog.setMessage("正在下载，请稍后");
            dialog.show();
            loadFile(loadBeans.get(0));
            handler = new LoadFileHandler(loadBeans);
        }

    }

    private void loadFile(OcrRootBean bean) {
        Map<String, String> map = new HashMap<>();
        map.put("fileName", bean.getIncludes().getCc_file().getFilePath());
        map.put("downloadName", bean.getIncludes().getCc_file().getFileName());
        HttpHolder.downLoad(map, new MainHttpCallBack("batch_load", this));
    }

    private LoadFileHandler handler;
    private int loadIndex = 0;

    public class LoadFileHandler extends Handler {
        List<OcrRootBean> loadList;

        public LoadFileHandler(List<OcrRootBean> list) {
            loadList = list;
        }

        @Override
        public void handleMessage(Message msg) {
            int position = msg.arg1;
            switch (msg.what) {
                case 0:
                    Toast.makeText(MainActivity.this, loadList.get(position).getIncludes().getCc_file().getFileName() + "下载失败，请稍后重试", Toast.LENGTH_SHORT).show();
                    break;
                case 1:
                    loadIndex++;
                    if (loadIndex < loadList.size())
                        loadFile(loadList.get(loadIndex));
                    else {
                        dialog.dismiss();
                        handleShareAction(selectedInfos);
                    }
                    break;
            }
        }
    }

    private void handleShareAction(List<OcrRootBean> rootBeen) {
        //分享文件
        Intent intent = new Intent(Intent.ACTION_SEND_MULTIPLE);//发送多个文件
        intent.setType("*/*");//多个文件格式
        intent.putParcelableArrayListExtra(Intent.EXTRA_STREAM, shareFileUris);//Intent.EXTRA_STREAM同于传输文件流
        startActivity(Intent.createChooser(intent, "多文件分享"));
        setHandleMenu(View.GONE);
    }

    @Override
    public void noticeMessage(List<OcrRootBean> list) {
        selectedInfos = list;
        num.setText("已选择" + list.size() + "个");
    }

    //xutils的接口回调
    @Override
    public void success(String type, String result) {
        if ("edit".equals(type)) {
            Toast.makeText(this, "修改成功", Toast.LENGTH_SHORT).show();
            adapter.notifyDataSetChanged();
        } else if ("delete".equals(type)) {
            try {
                JSONObject object = new JSONObject(result);
                String data = object.getString("message");
                if (data.contains("success")) {
                    Toast.makeText(this, "删除成功", Toast.LENGTH_SHORT).show();

                    adapter.notifyDataSetChanged();
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else if ("download".equals(type)) {
            Toast.makeText(this, "下载成功,再次点击可进行查看", Toast.LENGTH_SHORT).show();
        } else if ("batch_load".equals(type)) {
            Message message = Message.obtain();
            message.arg1 = loadIndex;
            message.what = 1;
            handler.sendMessage(message);
        }
    }

    @Override
    public void error(String type, Throwable t) {
        if ("batch_load".equals(type)) {
            Message message = Message.obtain();
            message.arg1 = loadIndex;
            handler.sendMessage(message);
        } else
            Toast.makeText(this, "网络连接异常，请调试=" + t.getMessage(), Toast.LENGTH_SHORT).show();
    }


}
