package cn.com.bril.androidocr.studio.http;

import org.json.JSONArray;
import org.xutils.common.Callback;
import org.xutils.common.util.KeyValue;
import org.xutils.http.RequestParams;
import org.xutils.http.body.MultipartBody;
import org.xutils.x;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import cn.com.bril.androidocr.studio.beans.OcrRootBean;
import cn.com.bril.androidocr.studio.configs.RequestConfig;
import cn.com.bril.androidocr.studio.interf.OnHttpListener;
import cn.com.bril.androidocr.studio.ui.activity.VertifyActivity;
import cn.com.bril.androidocr.studio.utils.GsonUtil;

/**
 * Created by sunny on 2018-3-12.
 */

public class HttpHolder {

    //add
    public static void exportFile(String url, Map<String,Object> map, VertifyActivity.HttpCallBack callBack){
        RequestParams params=new RequestParams(url);
        Iterator<Map.Entry<String,Object>> it = map.entrySet().iterator();
        while (it.hasNext()){
            Map.Entry<String,Object> entry = it.next();
            if(!"header".equals(entry.getKey()))
                params.addBodyParameter(entry.getKey(),String.valueOf(entry.getValue()));
            else
                params.addHeader("X-Auth-Token",String.valueOf(entry.getValue()));
        }
        x.http().post(params,callBack);
    }

    public static void upLoadFile(String path, VertifyActivity.HttpCallBack callBack){
        RequestParams params=new RequestParams(RequestConfig.UP_FILE);
        List<KeyValue> list = new ArrayList<>();
        list.add(new KeyValue("file", new File(path)));//文件流数据
//        list.add(new KeyValue("parameters", json.toString()));
        MultipartBody body = new MultipartBody(list, "UTF-8");
        //添加请求参数
        params.setRequestBody(body);
        x.http().post(params,callBack);
    };

    //创建记录
    public static void createFileRecord(String url,Map<String,Object> map,Callback.CommonCallback<String> listener){
        RequestParams params=new RequestParams(url);
        Iterator<Map.Entry<String,Object>> it = map.entrySet().iterator();
        while (it.hasNext()){
            Map.Entry<String,Object> entry = it.next();
            if(!"header".equals(entry.getKey()))
                params.addBodyParameter(entry.getKey(),String.valueOf(entry.getValue()));
            else
                params.addHeader("X-Auth-Token",String.valueOf(entry.getValue()));
        }
        x.http().post(params,listener);

    }
    //批量导出

    /**
     *
     * @param infos
     * @param http
     */
    public static void volumeExport(List<OcrRootBean.Superior> infos, final OnHttpListener http){
        RequestParams params=new RequestParams(RequestConfig.BATCH_EXPORT_URL);
        params.addHeader("X-Auth-Token","ocr");
        String json=  GsonUtil.getInstance().toJson(infos);
        params.addBodyParameter("params",json);
        x.http().get(params, new Callback.CommonCallback<String>() {
            @Override
            public void onSuccess(String result) {
                http.success("",result);
            }
            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
                http.error("",ex);
            }
            @Override
            public void onCancelled(CancelledException cex) {
            }
            @Override
            public void onFinished() {
            }
        });
    }
    //批量删除
    public static void volumeDelete(final List<OcrRootBean.Superior> list, final OnHttpListener listener){
        JSONArray array= new JSONArray();
        for(int i=0;i<list.size();i++)
           array.put(list.get(i).getId());
        RequestParams params=new RequestParams(RequestConfig.BATCH_DELETE_URL);
        params.addBodyParameter("ids",array.toString());

        x.http().post(params, new Callback.CommonCallback<String>() {
            @Override
            public void onSuccess(String result) {
                listener.success("delete",result);
            }
            @Override
            public void onError(Throwable ex, boolean isOnCallback) {
                listener.error("",ex);
            }
            @Override
            public void onCancelled(CancelledException cex) {
            }
            @Override
            public void onFinished() {
            }
        });
    }

    //单个下载
    public static void downLoad(Map<String,String> map,MainHttpCallBack callBack){
        RequestParams params=new RequestParams(RequestConfig.DOWN_LOAD_URL);
        Iterator<Map.Entry<String,String>> it = map.entrySet().iterator();
        while (it.hasNext()){
            Map.Entry<String,String> entry = it.next();
            params.addBodyParameter(entry.getKey(),String.valueOf(entry.getValue()));
        }
        x.http().get(params,callBack);
    }
}
