package cn.com.bril.androidocr.studio;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.preference.PreferenceManager;

import com.abbyy.mobile.ocr4.AssetDataSource;
import com.abbyy.mobile.ocr4.DataSource;
import com.abbyy.mobile.ocr4.Engine;
import com.abbyy.mobile.ocr4.FileLicense;
import com.abbyy.mobile.ocr4.License;
import com.abbyy.mobile.ocr4.RecognitionLanguage;

import org.xutils.x;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import cn.com.bril.androidocr.studio.engine.PreferenceUtils;
import cn.com.bril.androidocr.studio.engine.RecognitionContext;

/**
 * Created by csk on 2017-11-30.
 */

public class OcrApplication extends Application {

    private List<Activity> activities = new ArrayList<Activity>();
    private static OcrApplication instance;

    private static final String _licenseFile = "SRTD-0100-0006-4035-9158-3387.ABBYY.LICENSE";
    private static final String _applicationID = "SRTD-0100-0006-4035-9158-3387.ABBYY.ABBYY";
    private static final String _patternsFileExtension = ".mp3";
    private static final String _dictionariesFileExtension = ".mp3";
    private static final String _keywordsFileExtension = ".mp3";

    @Override
    public void onCreate() {
        super.onCreate();
        instance=this;
        x.Ext.init(this);
        //ocr engine init
        PreferenceManager.setDefaultValues( this, R.xml.preferences, true );
        final DataSource assetDataSrouce = new AssetDataSource( this.getAssets() );

        final List<DataSource> dataSources = new ArrayList<DataSource>();
        dataSources.add( assetDataSrouce );

        Engine.loadNativeLibrary();
        try {
            Engine.createInstance( dataSources, new FileLicense( assetDataSrouce,
                            this._licenseFile, this._applicationID ),
                    new Engine.DataFilesExtensions( this._patternsFileExtension,
                            this._dictionariesFileExtension,
                            this._keywordsFileExtension ) );

            RecognitionContext.createInstance( this );

            filterRecognitionLanguagesPreferences( RecognitionContext.getLanguagesAvailableForOcr(),
                    getString( R.string.key_recognition_languages_ocr ) );
            filterRecognitionLanguagesPreferences( RecognitionContext.getLanguagesAvailableForBcr(),
                    getString( R.string.key_recognition_languages_bcr ) );
        } catch( final IOException e ) {
        } catch( final License.BadLicenseException e ) {

        }

    }
    public void filterRecognitionLanguagesPreferences( final Set<RecognitionLanguage> availableLanguages,
                                                       final String preferenceKey ) {
        final Set<RecognitionLanguage> languages =
                PreferenceUtils.getRecognitionLanguages( this, preferenceKey );
        languages.retainAll( availableLanguages );
        PreferenceUtils.setRecognitionLanguages( this, preferenceKey, languages );
    }
    @Override
    public void onTerminate() {
        try {
            Engine.destroyInstance();
            RecognitionContext.destroyInstance();
        } catch( final IllegalStateException e ) {
        }
        super.onTerminate();
    }
    public static OcrApplication getInstance(){
        return instance;
    }
    public void addActivity(Activity activity){
        activities.add(activity);
    }
    public void finishActivity(Activity activity){
        if (activity!=null) {
            this.activities.remove(activity);
            activity.finish();
            activity = null;
        }
    }
    public void exit(){
        ActivityManager manager = (ActivityManager)getApplicationContext().getSystemService(ACTIVITY_SERVICE); //获取应用程序管理器
        manager.killBackgroundProcesses(getPackageName()); //强制结束当前应用程序
    }
    public void finishActivity(){
        for (Activity activity : activities) {
            if (null != activity) {
                activity.finish();
            }
        }
        //杀死该应用进程
        android.os.Process.killProcess(android.os.Process.myPid());
    }
}
