/*
 * Decompiled with CFR 0.152.
 */
package com.guanpb.poi.excel;

import com.guanpb.poi.excel.annotation.ExcelIgnore;
import com.guanpb.poi.excel.annotation.ExcelSheet;
import com.guanpb.poi.excel.util.FieldReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelImportUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelImportUtil.class);

    public static List<Object> importExcel(Class<?> sheetClass, Workbook workbook) {
        try {
            ExcelSheet excelSheet = sheetClass.getAnnotation(ExcelSheet.class);
            String sheetName = excelSheet != null && excelSheet.name() != null && excelSheet.name().trim().length() > 0 ? excelSheet.name().trim() : sheetClass.getSimpleName();
            ArrayList<Field> fields = new ArrayList<Field>();
            if (sheetClass.getDeclaredFields() != null && sheetClass.getDeclaredFields().length > 0) {
                for (Field field : sheetClass.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(ExcelIgnore.class) != null) continue;
                    fields.add(field);
                }
            }
            if (fields == null || fields.size() == 0) {
                throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data field can not be empty.");
            }
            Sheet sheet = workbook.getSheet(sheetName);
            Iterator sheetIterator = sheet.rowIterator();
            int rowIndex = 0;
            ArrayList<Object> dataList = new ArrayList<Object>();
            while (sheetIterator.hasNext()) {
                Row rowX = (Row)sheetIterator.next();
                if (rowIndex > 0) {
                    Object rowObj = sheetClass.newInstance();
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field = (Field)fields.get(i);
                        String fieldValueStr = rowX.getCell(i).getStringCellValue();
                        Object fieldValue = FieldReflectionUtil.parseValue(field, fieldValueStr);
                        field.setAccessible(true);
                        field.set(rowObj, fieldValue);
                    }
                    dataList.add(rowObj);
                }
                ++rowIndex;
            }
            return dataList;
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Object> importExcel(Class<?> sheetClass, File excelFile) {
        try {
            Workbook workbook = WorkbookFactory.create((File)excelFile);
            List<Object> dataList = ExcelImportUtil.importExcel(sheetClass, workbook);
            return dataList;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Object> importExcel(Class<?> sheetClass, String filePath) {
        File excelFile = new File(filePath);
        List<Object> dataList = ExcelImportUtil.importExcel(sheetClass, excelFile);
        return dataList;
    }

    public static List<Object> importExcel(Class<?> sheetClass, InputStream inputStream) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            List<Object> dataList = ExcelImportUtil.importExcel(sheetClass, workbook);
            return dataList;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

